package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleConnection;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleConnectionImporter.java 5052 2015-08-05 14:09:12Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycleConnection/PracticedCropCycleConnectionImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.CroppingEntryType;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleConnection;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCycleConnection;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCycleNode;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedSeasonalCropCycle;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImporter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 04/02/15.
 */
public class PracticedCropCycleConnectionImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycleConnectionImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycleConnection.class);

        PracticedCropCycleConnectionImportModel model = new PracticedCropCycleConnectionImportModel();
        // récupère le DTO
        Import<PracticedCropCycleConnectionImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleConnectionImportDto dto : importer) {
            boolean error;

            Pz0PracticedCropCycleConnection pz0Connection = new Pz0PracticedCropCycleConnection(dto.getId(), dto.getTargetId());
            PracticedCropCycleConnectionDto connectionDto = pz0Connection.getPracticedCropCycleConnectionDto();
            Binder<PracticedCropCycleConnectionImportDto, PracticedCropCycleConnectionDto> binder = BinderFactory.newBinder(PracticedCropCycleConnectionImportDto.class, PracticedCropCycleConnectionDto.class);
            binder.copyExcluding(dto, connectionDto,
                    "sourceId",
                    "targetId",
                    "intermediateCroppingPlanEntryCode");

            // valid required fields
            error = validSource(importResults, line, dto, false);

            error = validTarget(importResults, line, dto, error);

            error = validIntermediateCrop(importResults, line, dto, connectionDto, error);

            setSourceAndTargetToConnection(dto, connectionDto);
            addConnectionToCycle(dto, pz0Connection);
            pz0IdToObject.put(Pz0PracticedCropCycleConnection.class, dto.getId(), pz0Connection);

            if (!error) {
                importResults.addInfoLine(line, ", " + "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ VALIDÉE, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSource(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, boolean error) {
        String sourceId = connectionImportDto.getSourceId();

        if (StringUtils.isNotBlank(sourceId)) {
            Pz0PracticedCropCycleNode pz0Node = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, sourceId);
            if (pz0Node == null) {
                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, le noeud source avec comme identifiant %s n'a pu être retrouvé.", sourceId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'source' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    protected boolean validTarget(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, boolean error) {
        String targetId = connectionImportDto.getTargetId();

        if (StringUtils.isNotBlank(targetId)) {
            Pz0PracticedCropCycleNode pz0Node = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, targetId);
            if (pz0Node == null) {
                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, le noeud cible avec comme identifiant %s n'a pu être retrouvé.", targetId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'target' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    protected void addConnectionToCycle(PracticedCropCycleConnectionImportDto dto, Pz0PracticedCropCycleConnection pz0Connection) {
        Pz0PracticedCropCycleNode pz0Node = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, dto.getTargetId());
        if (pz0Node != null && StringUtils.isNotBlank(pz0Node.getPracticedSeasonalCropCycleId())) {
            Pz0PracticedSeasonalCropCycle seasonalCropCycleDto = (Pz0PracticedSeasonalCropCycle) pz0IdToObject.get(Pz0PracticedSeasonalCropCycle.class, pz0Node.getPracticedSeasonalCropCycleId());
            if (seasonalCropCycleDto != null) {
                seasonalCropCycleDto.addPz0Connection(pz0Connection);
                pz0IdToObject.put(PracticedSeasonalCropCycleDto.class, pz0Node.getPracticedSeasonalCropCycleId(), seasonalCropCycleDto);
            }
        }
    }

    protected void setSourceAndTargetToConnection(PracticedCropCycleConnectionImportDto dto, PracticedCropCycleConnectionDto connectionDto) {
        String sourceId = dto.getSourceId();
        String targetId = dto.getTargetId();
        if (StringUtils.isNotBlank(sourceId)) {
            Pz0PracticedCropCycleNode pz0SourceNode = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, sourceId);
            if (pz0SourceNode != null) { // 2015-08-05 eancelet : no need to throw an error here if pz0SourceNode is null as it is checked in the validSource method
                connectionDto.setSourceId(pz0SourceNode.getNodeDto().getNodeId());                
            }            
        }
        Pz0PracticedCropCycleNode pz0TargetedNode = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, targetId);
        connectionDto.setTargetId(pz0TargetedNode.getNodeDto().getNodeId());
    }


    protected boolean validIntermediateCrop(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, PracticedCropCycleConnectionDto connectionDto, boolean error) {
        if (!error && StringUtils.isNotBlank(connectionImportDto.getIntermediateCroppingPlanEntryCode())) {
            String cropCode = connectionImportDto.getIntermediateCroppingPlanEntryCode();

            Pz0PracticedCropCycleNode pz0Node = (Pz0PracticedCropCycleNode) pz0IdToObject.get(Pz0PracticedCropCycleNode.class, connectionImportDto.getTargetId());
            if (pz0Node != null) {
                DomainAndDependencies domainAndDependencies = PracticedCropCycleNodeImporter.getDomainAndDependenciesFromNode(pz0Node.getPracticedSeasonalCropCycleId());

                if (domainAndDependencies != null) {
                    PracticedSystemAndDependencies practicedSystemAndDependencies = PracticedCropCycleNodeImporter.getSeasonalCropCycleRelatedPracticedSystem(pz0Node.getPracticedSeasonalCropCycleId());
                    if (practicedSystemAndDependencies != null) {
                        PracticedSystem practicedSystem = practicedSystemAndDependencies.getPracticedSystem();
                        if (StringUtils.isNotBlank(practicedSystem.getCampaigns())) {
                            Set<Integer> campaigns = CommonService.GET_CAMPAIGNS_SET.apply(practicedSystem.getCampaigns());
                            Set<String> cropCodes = Sets.newHashSet();

                            if (campaigns != null) {
                                for (Integer campaign : campaigns) {
                                    Set<String> domainCropcodesForCampaign = domainCodeCampaignCropCode.get(domainAndDependencies.getCsvCode(), campaign);
                                    if (CollectionUtils.isNotEmpty(domainCropcodesForCampaign)) {
                                        cropCodes.addAll(domainCropcodesForCampaign);
                                    }
                                }
                            } else {
                                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, les campagnes suivante '%s', ne permettent pas de retrouver le domaine de la culture avec comme code %s.", practicedSystem.getCampaigns(), cropCode));
                                error = true;
                            }

                            if (!cropCodes.isEmpty()) {
                                if (cropCodes.contains(cropCode)) {
                                    String agrosystCode = pz0CodeToAgrosystCode.get(CroppingPlanEntryDto.class, cropCode);
                                    CroppingPlanEntryDto crop = domainAndDependencies.getCroppingPlanEntryDtosByPZ0Code().get(cropCode);
                                    if (CroppingEntryType.INTERMEDIATE.equals(crop.getType())) {
                                        connectionDto.setIntermediateCroppingPlanEntryCode(agrosystCode);
                                    } else {
                                        importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la culture ayant pour code '%s' n'est pas une culture intermédiaire.", cropCode));
                                        error = true;
                                    }
                                } else {
                                    importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la culture intermédiaire ayant pour code '%s' n'a pu être retrouvée sur les domaines ayant pour code '%s' pour les campagnes suivantes: %s.", cropCode, domainAndDependencies.getCsvCode(), practicedSystem.getCampaigns()));
                                    error = true;
                                }
                            } else {
                                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, aucune culture intermédiaire n'existe pour les domaines ayant pour code '%s' pour les campagnes suivantes: %s.", domainAndDependencies.getCsvCode(), practicedSystem.getCampaigns()));
                                error = true;
                            }
                        } else {
                            importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, aucune campagnes de renseigné pour le système synthétisé %s.",practicedSystemAndDependencies.getCsvId()));
                            error = true;
                        }
                    } else {
                        importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, le système synthétisé n'a pu être retrouvé, ou ses campagnes ne sont pas renseigné, impossible de validé l'affiliation de la culture");
                        error = true;
                    }
                } else {
                    importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, domaine non retrouvé pour la culture de la connexion, la validation de la clture intermédiaire ne peut-être réalisée." + connectionImportDto.getId());
                    error = true;
                }

            } else {
                importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, noeud cible non trouvé.");
                error = true;
            }

        }
        return error;
    }

}
