package fr.inra.agrosyst.services.pz0import.plot;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PlotImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/plot/PlotImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 29/01/15.
 */
class PlotImportModel extends AbstractAgrosystModelExtended<PlotImportDto> {


    PlotImportModel() {
        super();
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", PlotImportDto.PROPERTY_NAME);
        newMandatoryColumn("area", PlotImportDto.PROPERTY_AREA, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("pacilotnumber", PlotImportDto.PROPERTY_PAC_ILOT_NUMBER, INT_PARSER);
        newMandatoryColumn("latitude", PlotImportDto.PROPERTY_LATITUDE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("longitude", PlotImportDto.PROPERTY_LONGITUDE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("comment", PlotImportDto.PROPERTY_COMMENT);
        newMandatoryColumn("activityendcomment", PlotImportDto.PROPERTY_ACTIVITY_END_COMMENT);
        newMandatoryColumn("active", PlotImportDto.PROPERTY_ACTIVE, T_F_PARSER);
        newMandatoryColumn("outofzoning", PlotImportDto.PROPERTY_OUT_OF_ZONING, T_F_PARSER);
        newMandatoryColumn("zoningcomment", PlotImportDto.PROPERTY_ZONING_COMMENT);
        newMandatoryColumn("irrigationsystem", PlotImportDto.PROPERTY_IRRIGATION_SYSTEM, T_F_PARSER);
        newMandatoryColumn("fertigationsystem", PlotImportDto.PROPERTY_FERTIGATION_SYSTEM, T_F_PARSER);
        newMandatoryColumn("waterorigin", PlotImportDto.PROPERTY_WATER_ORIGIN);
        newMandatoryColumn("drainage", PlotImportDto.PROPERTY_DRAINAGE, T_F_PARSER);
        newMandatoryColumn("drainageyear", PlotImportDto.PROPERTY_DRAINAGE_YEAR, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("frostprotection", PlotImportDto.PROPERTY_FROST_PROTECTION, T_F_PARSER);
        newMandatoryColumn("hailprotection", PlotImportDto.PROPERTY_HAIL_PROTECTION, T_F_PARSER);
        newMandatoryColumn("rainproofprotection", PlotImportDto.PROPERTY_RAINPROOF_PROTECTION,T_F_PARSER);
        newMandatoryColumn("pestprotection", PlotImportDto.PROPERTY_PEST_PROTECTION, T_F_PARSER);
        newMandatoryColumn("otherequipment", PlotImportDto.PROPERTY_OTHER_EQUIPMENT);
        newMandatoryColumn("equipmentcomment", PlotImportDto.PROPERTY_EQUIPMENT_COMMENT);
        newMandatoryColumn("solstoniness", PlotImportDto.PROPERTY_SOL_STONINESS, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solmaxdepth", PlotImportDto.PROPERTY_SOL_MAX_DEPTH, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solorganicmaterialpercent", PlotImportDto.PROPERTY_SOL_ORGANIC_MATERIAL_PERCENT, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solhydromorphisms", PlotImportDto.PROPERTY_SOL_HYDROMORPHISMS, T_F_PARSER);
        newMandatoryColumn("soltotallimestone", PlotImportDto.PROPERTY_SOL_TOTAL_LIMESTONE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("sollimestone", PlotImportDto.PROPERTY_SOL_LIMESTONE, T_F_PARSER);
        newMandatoryColumn("solactivelimestone", PlotImportDto.PROPERTY_SOL_ACTIVE_LIMESTONE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solbattance", PlotImportDto.PROPERTY_SOL_BATTANCE, T_F_PARSER);
        newMandatoryColumn("solcomment", PlotImportDto.PROPERTY_SOL_COMMENT);
        newMandatoryColumn("adjacentcomment", PlotImportDto.PROPERTY_ADJACENT_COMMENT);
        newMandatoryColumn("waterflowdistance", "waterFlowDistanceImportedValue");
        newMandatoryColumn("irrigationsystemtype", "irrigationSystemTypeImportedValue");
        newMandatoryColumn("pompenginetype", "pompEngineTypeImportedValue");
        newMandatoryColumn("hosespositionning", "hosesPositionningImportedValue");
        newMandatoryColumn("frostprotectiontype", "frostProtectionTypeImportedValue");
        newMandatoryColumn("surfacetexture", "surfaceTextureId");
        newMandatoryColumn("soldepth", "solDepthId");
        newMandatoryColumn("solwaterph", "solWaterPhImportedValue");
        newMandatoryColumn("maxslope", "maxSlopeImportedValue");
        newMandatoryColumn("subsoiltexture", "subSoilTextureId");
        newMandatoryColumn("bufferstrip", "bufferStripImportedValue");
        newMandatoryColumn("location", "locationId");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("deletedzones", "deletedZones",T_F_PARSER);
        newMandatoryColumn("domain", "domain");
        newMandatoryColumn("growingsystem", "growingSystem");
        newMandatoryColumn("ground", "ground");
    }

    @Override
    public PlotImportDto newEmptyInstance() {
        return new PlotImportDto();
    }


}
