package fr.inra.agrosyst.services.pz0import.input;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: RefFertiMinUnifaImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/input/RefFertiMinUnifaImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.referential.ReferentialService;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.input.dto.RefFertiMinUNIFADto;
import fr.inra.agrosyst.services.pz0import.input.model.RefFertiMinUnifaModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 18/03/15.
 */
public class RefFertiMinUnifaImporter extends AbstractCSVImporter  {

    private static final Log log = LogFactory.getLog(RefFertiMinUnifaImporter.class);

    protected ReferentialService referentialService;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {

        ImportResults importResults = new ImportResults(RefFertiMinUNIFA.class);

        RefFertiMinUnifaModel model = new RefFertiMinUnifaModel();

        // récupère le DTO
        Import<RefFertiMinUNIFADto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;

        for (RefFertiMinUNIFADto dto : importer) {

            if (!referentialService.isValidRefFertiMinProduct(dto)) {
                importResults.addErrorLine(line, String.format("AJOUT DU PRODUIT FERTILISANT MINERAL '%s' IGNORÉE!, la composition n'est pas valide, le pourcentage de poids est > 100.", dto.getId()));
            } else {
                RefFertiMinUNIFA product = referentialService.getNewRefFertiMinUNIFA();
                Binder<RefFertiMinUNIFADto, RefFertiMinUNIFA> binder = BinderFactory.newBinder(RefFertiMinUNIFADto.class, RefFertiMinUNIFA.class);
                binder.copy(dto, product);
                importResults.addInfoLine(line, ", " + String.format("AJOUT DU PRODUIT FERTILISANT MINERAL '%s' VALIDÉE", dto.getId()));
                importResults.addEntity(dto.getId(), new EntityAndDependencies(product));
                importResults.increaseAddedRecords();
                pz0IdToObject.put(RefFertiMinUNIFA.class, dto.getId(), product);
            }

            line++;
        }
        return importResults;
    }

    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        referentialService = getServiceFactory().newService(ReferentialService.class);
    }
}
