package fr.inra.agrosyst.services.pz0import.effective.effectiveToolsCoupling;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveToolsCouplingImporter.java 5067 2015-08-26 09:34:48Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveToolsCoupling/EffectiveToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveIntervention;
import fr.inra.agrosyst.api.services.pz0.plot.PlotAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 13/04/15.
 */
public class EffectiveToolsCouplingImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectiveToolsCouplingImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectiveToolsCouplingImporter.class);

        EffectiveToolsCouplingImportModel model = new EffectiveToolsCouplingImportModel();
        // récupère le DTO
        Import<EffectiveToolsCouplingImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (EffectiveToolsCouplingImportDto dto : importer) {
            boolean error;

            // valid required related objets
            error = validToolsCouplingAffiliation(importResults, line, dto, false);
            error = validEffectiveInterventionAffiliation(importResults, line, dto, error);

            if (!error) {
                importResults.addInfoLine(line, ", " + String.format("COMBINAISON D'OUTIL '%s' AFFECTÉE À L'INTERVENTION '%s'", dto.getToolCouplingsId(), dto.getEffectiveInterventionId()));
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, String.format("ÉCHEC D'AFFECTATION DE LA COMBINAISON D'OUTIL '%s' À L'INTERVENTION '%s'", dto.getToolCouplingsId(), dto.getEffectiveInterventionId()));
            }
            line++;
        }
        return importResults;
    }

    protected boolean validEffectiveInterventionAffiliation(ImportResults importResults, long line, EffectiveToolsCouplingImportDto from, boolean error) {
        String effectiveInterventionId = from.getEffectiveInterventionId();
        if (StringUtils.isNotBlank(effectiveInterventionId)) {
            Pz0EffectiveIntervention interventionDto = (Pz0EffectiveIntervention) pz0IdToObject.get(Pz0EffectiveIntervention.class, effectiveInterventionId);
            if (interventionDto != null) {
                error = addToolsCouplingToIntervention(importResults, line, from, error, interventionDto);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, l'intervention avec comme identifiant %s n'a pu etre retrouvée.", effectiveInterventionId));
            }        
        
            // test interventionType coherence with mainsactionToolscouplingType
            Pz0EffectiveIntervention pz0Intervention = (Pz0EffectiveIntervention) pz0IdToObject.get(Pz0EffectiveIntervention.class, effectiveInterventionId);
            if (pz0Intervention != null) {
                AgrosystInterventionType interventionType = pz0Intervention.getEffectiveInterventionDto().getType();
                if (interventionType != null && !StringUtils.isEmpty(from.getToolCouplingsId())) {
                    ToolsCoupling tool  = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, from.getToolCouplingsId());
                    if (tool != null) {    
                        Set<AgrosystInterventionType> mainsActionInAllToolsCoupling = new HashSet<AgrosystInterventionType>();
                        Collection<RefInterventionAgrosystTravailEDI> mainsActionsInTool = tool.getMainsActions();
                        if (mainsActionsInTool != null) {
                            for (RefInterventionAgrosystTravailEDI interventionAgrosystTravailEDI : tool.getMainsActions()) {
                                mainsActionInAllToolsCoupling.add(interventionAgrosystTravailEDI.getIntervention_agrosyst());
                            }  
                        }
                        if (!mainsActionInAllToolsCoupling.contains(interventionType)){
                            String mainsActionTypes = "";
                            for (AgrosystInterventionType mainActionType : mainsActionInAllToolsCoupling) {
                                mainsActionTypes = mainsActionTypes + " " + mainActionType;
                            }
                            error = true;
                            importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le type de l'intervention (%s, %s) ne correspond pas au type des mainsActions de la combinaison d'outils '%s' (%s).", interventionType, effectiveInterventionId, from.getToolCouplingsId(), mainsActionTypes));
                        }
                    }    
                }  
            }
        } else {
            importResults.addErrorLine(line, "AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, la colonne 'effectiveintervention' n'est pas renseignée");
            error = true;
        }
        return error;
    }

    protected boolean addToolsCouplingToIntervention(ImportResults importResults, long line, EffectiveToolsCouplingImportDto from, boolean error, Pz0EffectiveIntervention pz0Intervention) {
        ToolsCoupling toolsCoupling = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, from.getToolCouplingsId());
        if (toolsCoupling != null) {
            pz0Intervention.getEffectiveInterventionDto().addToolsCouplingCodes(toolsCoupling.getCode());
        } else {
            error = true;
            importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, la combinaison d'outil avec comme id %s n'a pas été retrouvée.", from.getToolCouplingsId()));
        }
        return error;
    }

    protected boolean validToolsCouplingAffiliation(ImportResults importResults, long line, EffectiveToolsCouplingImportDto from, boolean error) {
        String toolCouplingsId = from.getToolCouplingsId();
        if (!error && StringUtils.isNotBlank(toolCouplingsId)) {

            String interventionId = from.getEffectiveInterventionId();
            if (StringUtils.isNotBlank(interventionId)) {
                Pz0EffectiveIntervention pz0EffectiveIntervention = (Pz0EffectiveIntervention) pz0IdToObject.get(Pz0EffectiveIntervention.class, interventionId);

                if (pz0EffectiveIntervention != null) {
                    String zoneId = pz0EffectiveIntervention.getZoneId();
                    if (StringUtils.isNotBlank(zoneId)) {
                        PlotAndDependencies plotAndDependencies = (PlotAndDependencies) pz0IdToRelatedObjectId.get(Zone.class, PlotAndDependencies.class, zoneId);
                        if (plotAndDependencies != null) {
                            DomainAndDependencies domainAndDependencies = plotAndDependencies.getDomainAndDependencies();
                            Set<String> toolsCouplingIds = domainAndDependencies.getToolsCouplingIds();

                            if (toolsCouplingIds == null || (!toolsCouplingIds.contains(toolCouplingsId))) {
                                error = true;
                                importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, la combinaison d'outil %s n'a pas été retrouvé sur le domaine %s lié à l'intervention %s.", toolCouplingsId, domainAndDependencies.getCsvId(), interventionId));
                            }
                        } else {
                            error = true;
                            importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, aucune parcelle liée à la zone %s de l'intervention %s n'a pas été retrouvée.", zoneId, interventionId));
                        }
                    } else {
                        error = true;
                        importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, aucune zone trouvée avec comme identifiant '%s' ", zoneId));
                    }

                } else {
                    error= true;
                    importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, aucune zone liée à l'intervention %s n'a pas été retrouvée.", interventionId));
                }
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, intervention %s non retrouvée.", interventionId));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "AFFECTATION DE LA COMBINAISON D'OUTIL IGORÉE!, la colonne 'toolcouplings' n'est pas renseignée.");
        }
        return error;
    }




}