package fr.inra.agrosyst.services.pz0import.effective.effectivePhase;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectivePhaseImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectivePhase/EffectivePhaseImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveCropCyclePhase;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 01/04/15.
 */
public class EffectivePhaseImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectivePhaseImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectivePhaseImportDto.class);
        log.debug("importfromstream");

        EffectivePhaseImportModel model = new EffectivePhaseImportModel();
        // récupère le DTO
        Import<EffectivePhaseImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (EffectivePhaseImportDto dto : importer) {
            boolean error;

            Pz0EffectiveCropCyclePhase pz0Phase = new Pz0EffectiveCropCyclePhase(dto.getId());
            EffectiveCropCyclePhaseDto phase = pz0Phase.getPhase();

            // EffectivePerennialCropCycle to persist
            Binder<EffectivePhaseImportDto, EffectiveCropCyclePhaseDto> binder = BinderFactory.newBinder(EffectivePhaseImportDto.class, EffectiveCropCyclePhaseDto.class);
            binder.copyExcluding(dto, phase,
                    EffectiveCropCyclePhaseDto.PROPERTY_TOPIA_ID,
                    EffectiveCropCyclePhaseDto.PROPERTY_TYPE);

            // valid required enums
            error = validType(importResults, line, dto, phase, false);

            pz0IdToObject.put(Pz0EffectiveCropCyclePhase.class, dto.getId(), pz0Phase);

            if (!error) {
                importResults.addInfoLine(line, ", " + "PHASE DU RÉALISÉ VALIDÉE, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "PHASE DU RÉALISÉ IGNORÉE csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validType(ImportResults importResults, long line, EffectivePhaseImportDto dto, EffectiveCropCyclePhaseDto phase, boolean error) {
        String phaseType = dto.getType();
        if (StringUtils.isNotBlank(phaseType)) {
            CropCyclePhaseType type = null;
            try {
                type = CropCyclePhaseType.valueOf(phaseType);
            } catch (IllegalArgumentException e) {
                importResults.addErrorLine(line, String.format("PHASE DU RÉALISÉ IGNORÉE!, le type de phase '%s' n'est pas reconnu pour la phase d'id: %s", phaseType, dto.getId()));
                error = true;
            }
            phase.setType(type);
        } else {
            importResults.addErrorLine(line, "PHASE DU RÉALISÉ IGNORÉE!, la colonne 'type' n'est pas renseignée pour le cycle d'id: " + dto.getId());
            error = true;
        }
        return error;
    }

}
