package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GroundImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/GroundImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.GroundImportDto;

/**
 * Created by davidcosse on 05/05/15.
 */
public class GroundImportModel extends AbstractAgrosystModelExtended<GroundImportDto> {

    public GroundImportModel() {
        super();

        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", "name");
        newMandatoryColumn("comment", "comment");
        newMandatoryColumn("importance", "importance",DOUBLE_PARSER);
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("domain", "domainId");
        newMandatoryColumn("refsolarvalis", "refSolArvalisId");
    }

    @Override
    public GroundImportDto newEmptyInstance() {
        return new GroundImportDto();
    }

}
