package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: MainActionForToolsCouplingImporter.java 5058 2015-08-13 12:25:42Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/MainActionForToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.MainActionForToolsCoupling;
import fr.inra.agrosyst.services.pz0import.domain.model.MainActionsToolsCouplingImportModel;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

/**
 * Created by davidcosse on 18/12/14.
 */
public class MainActionForToolsCouplingImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(MainActionForToolsCouplingImporter.class);

    protected RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDIDao;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(MainActionForToolsCoupling.class);

        MainActionsToolsCouplingImportModel model = new MainActionsToolsCouplingImportModel();
        Import<MainActionForToolsCoupling> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (MainActionForToolsCoupling dto : importer) {

            ToolsCoupling toolsCoupling = null;
            if (StringUtils.isNotBlank(dto.getToolsCouplingId())) {
                toolsCoupling  = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, dto.getToolsCouplingId());
                if (toolsCoupling == null) {
                    importResults.addErrorLine(line, String.format("ACTION PRINCIPALE IGNORÉE, la combinaison d'outil avec comme identifiant %s n'existe pas ! ", dto.getToolsCouplingId()));
                }
            } else {
                importResults.addErrorLine(line, "ACTION PRINCIPALE IGNORÉE, colonne 'toolscoupling' non renseignée");
            }

            RefInterventionAgrosystTravailEDI mainAction = null;
            if (StringUtils.isNotBlank((dto.getMainsactions()))) {
                mainAction = refInterventionAgrosystTravailEDIDao.forTopiaIdEquals(dto.getMainsactions()).findUniqueOrNull();
                if (mainAction == null) {
                    importResults.addErrorLine(line, String.format("ACTION PRINCIPALE IGNORÉE, l'action principale avec comme code de référence %s n'existe pas !", dto.getMainsactions()));
                }
            } else {
                importResults.addErrorLine(line, "ACTION PRINCIPALE IGNORÉE, colonne 'mainsactions' non renseignée");
            }

            if (toolsCoupling != null && mainAction != null) {
                // for a toolscoupling, only one action per intervention type (except vineyard and orchard maintenance)
                Collection<RefInterventionAgrosystTravailEDI> mainsactionInToolscoupling = toolsCoupling.getMainsActions();                
                boolean sameActionInTool = false;
                boolean sameActionTypeInTool = false;
                if (mainsactionInToolscoupling != null && !mainsactionInToolscoupling.isEmpty()) {
                    Iterator mainsactionIterator = mainsactionInToolscoupling.iterator();
                    while (!sameActionInTool && !sameActionTypeInTool && mainsactionIterator.hasNext()) {
                        RefInterventionAgrosystTravailEDI mainactionInTool = (RefInterventionAgrosystTravailEDI) mainsactionIterator.next();
                        if (StringUtils.equals(mainAction.getReference_code(), mainactionInTool.getReference_code())) {
                            importResults.addInfoLine(line, ", " + String.format("WARN : ACTION PRINCIPALE %s NON AJOUTÉE à la combinaison d'outil %s car une action identique a déjà été ajoutée", dto.getMainsactions(), dto.getToolsCouplingId()));
                            importResults.increaseIgnoredRecords();
                            sameActionInTool = true;
                        } else if (mainAction.getIntervention_agrosyst().equals(mainactionInTool.getIntervention_agrosyst()) && !mainAction.getIntervention_agrosyst().equals(AgrosystInterventionType.ENTRETIEN_TAILLE_VIGNE_ET_VERGER)) {
                            importResults.addErrorLine(line, ", " + String.format("ACTION PRINCIPALE %s NON AJOUTÉE à la combinaison d'outil %s car une action de même type y est déjà associée", dto.getMainsactions(), dto.getToolsCouplingId()));                        
                            importResults.increaseIgnoredRecords();
                            sameActionTypeInTool = true;
                        }
                    }   
                }
                if (!sameActionInTool && !sameActionTypeInTool) {
                    toolsCoupling.addMainsActions(mainAction);
                    importResults.addInfoLine(line, ", " + String.format("ACTION PRINCIPALE %s AJOUTÉE à la combinaison d'outil %s", dto.getMainsactions(), dto.getToolsCouplingId()));
                    importResults.increaseAddedRecords();
                }
            } else {
                importResults.increaseIgnoredRecords();
            }

            line++;
        }
        return  importResults;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        refInterventionAgrosystTravailEDIDao = getPersistenceContext().getRefInterventionAgrosystTravailEDIDao();
    }
}
