package fr.inra.agrosyst.services.pz0import.action.harvestingYeald;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: HarvestingYealdModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.2/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/harvestingYeald/HarvestingYealdModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 12/02/15.
 */
class HarvestingYealdModel extends AbstractAgrosystModelExtended<HarvestingYealdImportDto> {

    HarvestingYealdModel() {
        super();
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("yealdmin", HarvestingYeald.PROPERTY_YEALD_MIN, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdmax", HarvestingYeald.PROPERTY_YEALD_MAX, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdaverage", "yealdAverageWithNull", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdmedian", HarvestingYeald.PROPERTY_YEALD_MEDIAN, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdcategory", "yealdCategoryName");
        newMandatoryColumn("yealdunit", "yealdUnitName");
        newMandatoryColumn("harvestingaction", "harvestingActionId");
    }

    @Override
    public HarvestingYealdImportDto newEmptyInstance() {
        return new HarvestingYealdImportDto();
    }
}
