package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedSeasonalCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedSeasonalCropCycleImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedSeasonalCropCycle/PracticedSeasonalCropCycleImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSeasonalCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedSeasonalCropCycle;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle.PracticedCropCycleImportDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 03/02/15.
 */
public class PracticedSeasonalCropCycleImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedSeasonalCropCycle.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedSeasonalCropCycle.class);

        PracticedSeasonalCropCycleImportModel model = new PracticedSeasonalCropCycleImportModel();
        // récupère le DTO
        Import<PracticedSeasonalCropCycleImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedSeasonalCropCycleImportDto dto : importer) {
            boolean error;

            Pz0PracticedSeasonalCropCycle pz0SeasonalCropCycle = new Pz0PracticedSeasonalCropCycle(dto.getId());
            // valid required fields
            error = validPracticedSystemAffiliationAndAddCycleToPS(importResults, line, dto, pz0SeasonalCropCycle, false);

            pz0IdToObject.put(Pz0PracticedSeasonalCropCycle.class,  dto.getId(), pz0SeasonalCropCycle);
            if (!error) {
                importResults.addInfoLine(line, ", " + "CYCLE SAISONIER DE CULTURE DU SYNTHÉTISÉ VALIDÉ, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CYCLE SAISONIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validPracticedSystemAffiliationAndAddCycleToPS(ImportResults importResults, long line, PracticedSeasonalCropCycleImportDto dto, Pz0PracticedSeasonalCropCycle pz0cycle, boolean error) {
        String practicedCropCycleId = dto.getId();
        if (StringUtils.isNotBlank(practicedCropCycleId)) {
            PracticedCropCycleImportDto practicedCropCycleImportDto = (PracticedCropCycleImportDto) pz0IdToObject.get(PracticedCropCycle.class, practicedCropCycleId);

            if (practicedCropCycleImportDto != null) {
                PracticedSystemAndDependencies practicedSystemAndDependencies = (PracticedSystemAndDependencies) pz0IdToObject.get(PracticedSystem.class, practicedCropCycleImportDto.getPracticedSystemId());

                if (practicedSystemAndDependencies != null) {
                    practicedSystemAndDependencies.addPracticedSeasonalCropCycleDto(pz0cycle);
                } else {
                    importResults.addErrorLine(line, String.format("CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, aucun système pratiqué n'est retrouvé avec l'identifiant suivant: %s", practicedCropCycleImportDto.getPracticedSystemId()));
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, String.format("CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, aucun cycle pratiqué n'est retrouvé avec l'identifiant suivant: %s", practicedCropCycleId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'topiaId' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

}
