package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedInterventionToolsCoupling;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedToolsCouplingImporter.java 5094 2015-10-09 09:33:16Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedInterventionToolsCoupling/PracticedToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Sets;

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDI;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCycleConnection;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCycleNode;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCyclePhase;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedIntervention;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.PracticedSystemImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle.PracticedCropCycleImportDto;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImporter;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 06/02/15.
 */
public class PracticedToolsCouplingImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedToolsCouplingImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedToolsCouplingImportDto.class);

        PracticedToolsCouplingImportModel model = new PracticedToolsCouplingImportModel();
        // récupère le DTO
        Import<PracticedToolsCouplingImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedToolsCouplingImportDto dto : importer) {
            boolean error;

            // valid required fields
            error = validToolsCouplingInterventionAssociation(importResults, line, dto, false);

            error = validToolsCouplingCode(importResults, line, dto, error);

            if (!error && dto.getInterventionDto() != null) {
                String agrosystTCCode = pz0CodeToAgrosystCode.get(ToolsCoupling.class, dto.getToolsCouplingCode());
                dto.getInterventionDto().addToolsCouplingCode(agrosystTCCode);
            }

            if (!error) {
                importResults.addInfoLine(line, ", " + "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION VALIDÉE");
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE");
            }
            line++;
        }
        return importResults;
    }

    protected boolean validToolsCouplingInterventionAssociation(ImportResults importResults, long line, PracticedToolsCouplingImportDto from, boolean error) {
        
        // test interventionId
        String interventionId = from.getInterventionId();                
        if(StringUtils.isNotBlank(interventionId)){
            Pz0PracticedIntervention pz0Intervention = (Pz0PracticedIntervention)pz0IdToObject.get(Pz0PracticedIntervention.class, interventionId);
            if(pz0Intervention != null) {
                from.setInterventionDto(pz0Intervention.getPracticedInterventionDto());
            } else {
                importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, l'intervention avec comme id: %s n'a pu être retrouvée.", interventionId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la colonne 'owner' doit-être renseignés.");
            error = true;
        }
        
        // test interventiontype coherence with mainsactionToolscouplingType
        if (from.getInterventionDto() != null) {
            AgrosystInterventionType interventionType = from.getInterventionDto().getType();
            if (interventionType != null && !StringUtils.isEmpty(from. getToolsCouplingCode())) {
                List<ToolsCoupling> toolsCouplings  = (List<ToolsCoupling>) pz0CodeToObject.get(ToolsCoupling.class, from.getToolsCouplingCode());
                if (toolsCouplings != null && !toolsCouplings.isEmpty()) {    
                    Set<AgrosystInterventionType> mainsActionInAllToolsCoupling = new HashSet<AgrosystInterventionType>();
                    for (ToolsCoupling tool : toolsCouplings) {
                        Collection<RefInterventionAgrosystTravailEDI> mainsActionsInTool = tool.getMainsActions();
                        if (mainsActionsInTool != null) {
                            for (RefInterventionAgrosystTravailEDI interventionAgrosystTravailEDI : tool.getMainsActions()) {
                                mainsActionInAllToolsCoupling.add(interventionAgrosystTravailEDI.getIntervention_agrosyst());
                            }  
                        }
                    }
                    if (!mainsActionInAllToolsCoupling.contains(interventionType)){
                        String mainsActionTypes = "";
                        for (AgrosystInterventionType mainActionType : mainsActionInAllToolsCoupling) {
                            mainsActionTypes = mainsActionTypes + " " + mainActionType;
                        }
                        error = true;
                        importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le type de l'intervention (%s, %s) ne correspond pas au type des mainsActions de la combinaison d'outils '%s' (%s).", interventionType, interventionId, from.getToolsCouplingCode(), mainsActionTypes));
                    }
                }    
            }
        }
        return error;
    }

    protected boolean validToolsCouplingCode(ImportResults importResults, long line, PracticedToolsCouplingImportDto from, boolean error) {
        if(!error) {
            String toolsCouplingCode = from.getToolsCouplingCode();
            if (StringUtils.isNotBlank(toolsCouplingCode)){
                String connectionId = (String) pz0IdToObject.get(PracticedInterventionDto.class, PracticedCropCycleConnectionDto.class, from.getInterventionId());
                if (StringUtils.isNotBlank(connectionId)) {
                    Pz0PracticedCropCycleConnection pz0Connection = (Pz0PracticedCropCycleConnection)pz0IdToObject.get(Pz0PracticedCropCycleConnection.class, connectionId);
                    if (pz0Connection != null) {
                        String newNodeId = pz0Connection.getPracticedCropCycleConnectionDto().getTargetId();
                        String nodeId = StringUtils.remove(newNodeId, "new-node-");
                        Pz0PracticedCropCycleNode pz0Node = (Pz0PracticedCropCycleNode)pz0IdToObject.get(Pz0PracticedCropCycleNode.class, nodeId);
                        if (pz0Node != null && StringUtils.isNotBlank(pz0Node.getPracticedSeasonalCropCycleId())) {
                            DomainAndDependencies domainAndDependencies = PracticedCropCycleNodeImporter.getDomainAndDependenciesFromNode(pz0Node.getPracticedSeasonalCropCycleId());
                            PracticedSystemAndDependencies practicedSystemAndDependencies = PracticedCropCycleNodeImporter.getSeasonalCropCycleRelatedPracticedSystem(pz0Node.getPracticedSeasonalCropCycleId());
                            error = validToolsCouplingExistsForPracticedSystem(importResults, line, toolsCouplingCode, domainAndDependencies, practicedSystemAndDependencies);

                        } else {
                            importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, le noeud avec comme identifiant %s de la connexion avec comme identifiant %s sur laquelle porte l'intervention n'a pu être retrouvé.", nodeId, connectionId));
                            error = true;
                        }
                    } else {
                        importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, échec de récupération de la connexion avec comme identifiant: " + connectionId);
                        error = true;
                    }


                } else {
                    String phaseId = (String) pz0IdToObject.get(PracticedInterventionDto.class, PracticedCropCyclePhaseDto.class, from.getInterventionId());
                    if (StringUtils.isNotBlank(phaseId)) {
                        Pz0PracticedCropCyclePhase pz0Phase = (Pz0PracticedCropCyclePhase) pz0IdToObject.get(Pz0PracticedCropCyclePhase.class, phaseId);
                        if (pz0Phase != null) {
                            String practicedPerennialCropCycleId = pz0Phase.getPracticedPerennialCropCycleId();
                            if (StringUtils.isNotBlank(practicedPerennialCropCycleId)) {
                                PracticedCropCycleImportDto cropCycleDto = (PracticedCropCycleImportDto) pz0IdToObject.get(PracticedCropCycle.class, practicedPerennialCropCycleId);
                                if (cropCycleDto != null) {
                                    PracticedSystemAndDependencies practicedSystemAndDependencies = (PracticedSystemAndDependencies) pz0IdToObject.get(PracticedSystem.class, cropCycleDto.getPracticedSystemId());
                                    if (practicedSystemAndDependencies != null) {
                                        DomainAndDependencies domainAndDependencies = PracticedSystemImporter.getDomainAndDependenciesFromPracticedSystem(practicedSystemAndDependencies.getEntity());
                                        error = validToolsCouplingExistsForPracticedSystem(importResults, line, toolsCouplingCode, domainAndDependencies, practicedSystemAndDependencies);
                                    } else {
                                        error = true;
                                        importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, le système synthétisé avec comme identifiant %s de la phase %s sur laquelle porte l'intervention n'a pu être retrouvé.",  cropCycleDto.getPracticedSystemId(), phaseId));
                                    }
                                } else {
                                    error = true;
                                    importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, le cycle de culture pérenne avec comme identifiant %s de la phase %s sur laquelle porte l'intervention n'a pu être retrouvé.",  practicedPerennialCropCycleId, phaseId));
                                }
                            } else {
                                error = true;
                                importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, le cycle de culture pérenne n' a pu être retrouvé à partir de la phase %s.",  phaseId));
                            }
                        } else {
                            error = true;
                            importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, le cycle de culture pérenne n' a pu être retrouvé à partir de la phase %s.",  phaseId));
                        }
                    } else {
                        error = true;
                        importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée, la phase liée à l'intervention %s n' a pu être retrouvée.",  from.getInterventionId()));
                    }
                }
            } else {
                importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la colonne 'toolscouplingcodes' doit-être renseignés.");
                error = true;
            }
        }

        return error;
    }

    protected boolean validToolsCouplingExistsForPracticedSystem(ImportResults importResults, long line, String toolsCouplingCode, DomainAndDependencies domainAndDependencies, PracticedSystemAndDependencies practicedSystemAndDependencies) {
        boolean error = false;
        if (domainAndDependencies != null && practicedSystemAndDependencies != null) {
            PracticedSystem practicedSystem = practicedSystemAndDependencies.getPracticedSystem();
            if (practicedSystem != null && StringUtils.isNotBlank(practicedSystem.getCampaigns())) {
                Set<Integer> campaigns = CommonService.GET_CAMPAIGNS_SET.apply(practicedSystem.getCampaigns());
                Set<String> toolsCouplingCodes = Sets.newHashSet();

                if (campaigns != null) {
                    for (Integer campaign : campaigns) {
                        Set<String> domainTCCodesForCampaign = domainCodeCampaignTCCode.get(domainAndDependencies.getCsvCode(), campaign);
                        if (CollectionUtils.isNotEmpty(domainTCCodesForCampaign)) {
                            toolsCouplingCodes.addAll(domainTCCodesForCampaign);
                        }
                    }
                } else {
                    importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, les campagnes suivante '%s' sur le système synthétisé suivant %s, ne permettent pas de retrouver le domaine de la combinaison d'outil avec comme code %s.", practicedSystem.getCampaigns(), practicedSystemAndDependencies.getCsvId(), toolsCouplingCode));
                    error = true;
                }

                if (!toolsCouplingCodes.isEmpty()) {

                    if (!toolsCouplingCodes.contains(toolsCouplingCode)) {
                        importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la combinaison d'outil avec pour code '%s' n'a pu être retrouvée sur les domaines ayant pour code '%s' pour les campagnes suivantes: %s du système synthétisé %s.", toolsCouplingCode, domainAndDependencies.getCsvCode(), practicedSystem.getCampaigns(), practicedSystemAndDependencies.getCsvId()));
                        error = true;
                    }
                } else {
                    importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, aucune combinaison d'outil existe pour les domaines ayant pour code '%s' pour les campagnes suivantes: %s du système synthétisé %s.", domainAndDependencies.getCsvCode(), practicedSystem.getCampaigns(), practicedSystemAndDependencies.getCsvId()));
                    error = true;
                }

            } else {
                importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, les campagnes du système synthétisé  %s ne sont pas renseignées, impossible de validé l'affiliation de la combinaison d'outil avec le domaine", practicedSystemAndDependencies.getCsvId()));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, le domaine de la combinaison d'outil n'a pu être retrouvée.");
            error = true;
        }
        return error;
    }

}
