package fr.inra.agrosyst.services.pz0import.input.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: RefFertiMinUnifaModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/input/model/RefFertiMinUnifaModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.referential.RefFertiMinUNIFA;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.input.dto.RefFertiMinUNIFADto;

/**
 * Created by davidcosse on 18/03/15.
 */
public class RefFertiMinUnifaModel extends AbstractAgrosystModelExtended<RefFertiMinUNIFADto> {


    public RefFertiMinUnifaModel() {
        super();
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("categ", RefFertiMinUNIFA.PROPERTY_CATEG, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("forme", RefFertiMinUNIFA.PROPERTY_FORME);
        newMandatoryColumn("n", RefFertiMinUNIFA.PROPERTY_N, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("p2o5", RefFertiMinUNIFA.PROPERTY_P2_O5, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("k2o", RefFertiMinUNIFA.PROPERTY_K2_O, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("bore", RefFertiMinUNIFA.PROPERTY_BORE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("calcium", RefFertiMinUNIFA.PROPERTY_CALCIUM, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("fer", RefFertiMinUNIFA.PROPERTY_FER, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("manganese", RefFertiMinUNIFA.PROPERTY_MANGANESE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("molybdene", RefFertiMinUNIFA.PROPERTY_MOLYBDENE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("mgo", RefFertiMinUNIFA.PROPERTY_MG_O, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("oxyde_de_sodium", RefFertiMinUNIFA.PROPERTY_OXYDE_DE_SODIUM, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("so3",RefFertiMinUNIFA.PROPERTY_S_O3, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("cuivre", RefFertiMinUNIFA.PROPERTY_CUIVRE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("zinc", RefFertiMinUNIFA.PROPERTY_ZINC, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("type_produit", RefFertiMinUNIFA.PROPERTY_TYPE_PRODUIT);
        newMandatoryColumn("codeprod", RefFertiMinUNIFA.PROPERTY_CODEPROD);
        newMandatoryColumn("source", RefFertiMinUNIFA.PROPERTY_SOURCE);
        newMandatoryColumn("active", RefFertiMinUNIFA.PROPERTY_ACTIVE, T_F_PARSER);
    }

    @Override
    public RefFertiMinUNIFADto newEmptyInstance() {
        return new RefFertiMinUNIFADto();
    }
}
