package fr.inra.agrosyst.services.pz0import.input.dto;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: InputImportDto.java 5118 2015-10-29 14:26:43Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/input/dto/InputImportDto.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import org.apache.commons.lang3.StringUtils;

/**
 * Created by davidcosse on 24/02/15.
 */
public class InputImportDto {

    protected String id;

    protected String topiaDiscriminator;

    protected Double qtMin;

    protected Double qtAvg;

    protected Double qtMed;

    protected Double qtMax;

    protected String productName;

    protected String inputTypeName;

    protected String biologicalControlActionId;

    protected String harvestingActionId;

    protected String irrigationActionId;

    protected String mineralProductId;

    protected String mineralProductUnitName;

    protected String mineralFertilizersSpreadingActionId;

    protected String organicFertilizersSpreadingActionId;

    protected String organicProductId;

    protected String otherProductQtUnit;

    protected String otherActionId;

    protected String productType;

    protected String phytoProductId;

    protected String phytoProductUnitName;

    protected String pesticidesSpreadingActionId;

    protected String seedingActionId;

    protected String maintenancePruningVinesActionId;

    protected boolean phytoEffect;

    protected Double n;

    protected Double p2o5;

    protected Double k2o;

    protected String organicProductUnitName;

    protected String pz0ActionId;

    public void setMineralProductUnitName(String mineralProductUnitName) {
        this.mineralProductUnitName = mineralProductUnitName;
    }

    public void setBiologicalControlActionId(String biologicalControlActionId) {
        this.biologicalControlActionId = biologicalControlActionId;
        setPz0ActionId(this.biologicalControlActionId);
    }

    public void setHarvestingActionId(String harvestingActionId) {
        this.harvestingActionId = harvestingActionId;
        setPz0ActionId(this.harvestingActionId);
    }

    public void setIrrigationActionId(String irrigationActionId) {
        this.irrigationActionId = irrigationActionId;
        setPz0ActionId(this.irrigationActionId);
    }

    public void setMaintenancePruningVinesActionId(String maintenancePruningVinesActionId) {
        this.maintenancePruningVinesActionId = maintenancePruningVinesActionId;
        setPz0ActionId(this.maintenancePruningVinesActionId);
    }

    public void setMineralFertilizersSpreadingActionId(String mineralFertilizersSpreadingActionId) {
        this.mineralFertilizersSpreadingActionId = mineralFertilizersSpreadingActionId;
        setPz0ActionId(this.mineralFertilizersSpreadingActionId);
    }

    public void setOrganicFertilizersSpreadingActionId(String organicFertilizersSpreadingActionId) {
        this.organicFertilizersSpreadingActionId = organicFertilizersSpreadingActionId;
        setPz0ActionId(this.organicFertilizersSpreadingActionId);
    }

    public void setOtherActionId(String otherActionId) {
        this.otherActionId = otherActionId;
        setPz0ActionId(this.otherActionId);
    }

    public void setPesticidesSpreadingActionId(String pesticidesSpreadingActionId) {
        this.pesticidesSpreadingActionId = pesticidesSpreadingActionId;
        setPz0ActionId(this.pesticidesSpreadingActionId);
    }

    public void setSeedingActionId(String seedingActionId) {
        this.seedingActionId = seedingActionId;
        setPz0ActionId(this.seedingActionId);
    }

    protected void setPz0ActionId(String pz0Id) {
        if(StringUtils.isBlank(this.pz0ActionId)) {
            this.pz0ActionId = pz0Id;
        }
    }

    public void setK2o(Double k2o) {
        this.k2o = k2o;
    }

    public void setOrganicProductId(String organicProductId) {
        this.organicProductId = organicProductId;
    }

    public void setOrganicProductUnitName(String organicProductUnitName) {
        this.organicProductUnitName = organicProductUnitName;
    }

    public void setOtherProductQtUnit(String otherProductQtUnit) {
        this.otherProductQtUnit = otherProductQtUnit;
    }

    public void setP2o5(Double p2o5) {
        this.p2o5 = p2o5;
    }

    public void setPhytoProductId(String phytoProductId) {
        this.phytoProductId = phytoProductId;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }


    public void setId(String id) {
        this.id = id;
    }

    public String getTopiaDiscriminator() {
        return topiaDiscriminator;
    }

    public void setTopiaDiscriminator(String topiaDiscriminator) {
        this.topiaDiscriminator = topiaDiscriminator;
    }

    public Double getQtMin() {
        return qtMin;
    }

    public void setQtMin(Double qtmin) {
        this.qtMin = qtmin;
    }

    public Double getQtAvg() {
        return qtAvg;
    }

    public void setQtAvg(Double qtAvg) {
        this.qtAvg = qtAvg;
    }

    public Double getQtMed() {
        return qtMed;
    }

    public void setQtMed(Double qtMed) {
        this.qtMed = qtMed;
    }

    public Double getQtMax() {
        return qtMax;
    }

    public void setQtMax(Double qtMax) {
        this.qtMax = qtMax;
    }

    public String getProductName() {
        return productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public String getInputTypeName() {
        return inputTypeName;
    }

    public void setInputTypeName(String inputTypeName) {
        this.inputTypeName = inputTypeName;
    }

    public String getId() {
        return id;
    }

    public String getMineralProductId() {
        return mineralProductId;
    }

    public void setMineralProductId(String mineralProductId) {
        this.mineralProductId = mineralProductId;
    }

    public String getMineralProductUnitName() {
        return mineralProductUnitName;
    }

    public String getMineralFertilizersSpreadingActionId() {
        return mineralFertilizersSpreadingActionId;
    }

    public String getOtherProductQtUnit() {
        return otherProductQtUnit;
    }


    public String getOtherActionId() {
        return otherActionId;
    }

    public String getProductType() {
        return productType;
    }


    public String getPhytoProductId() {
        return phytoProductId;
    }


    public String getPhytoProductUnitName() {
        return phytoProductUnitName;
    }

    public void setPhytoProductUnitName(String phytoProductUnitName) {
        this.phytoProductUnitName = phytoProductUnitName;
    }

    public String getPesticidesSpreadingActionId() {
        return pesticidesSpreadingActionId;
    }

    public String getSeedingActionId() {
        return seedingActionId;
    }

    public String getBiologicalControlActionId() {
        return biologicalControlActionId;
    }

    public Double getN() {
        return n;
    }

    public void setN(Double n) {
        this.n = n;
    }

    public Double getP2o5() {
        return p2o5;
    }

    public Double getK2o() {
        return k2o;
    }

    public String getOrganicProductId() {
        return organicProductId;
    }


    public String getOrganicFertilizersSpreadingActionId() {
        return organicFertilizersSpreadingActionId;
    }

    public String getOrganicProductUnitName() {
        return organicProductUnitName;
    }

    public String getPz0ActionId() {
        return pz0ActionId;
    }

    public String getHarvestingActionId() {
        return harvestingActionId;
    }

    public String getIrrigationActionId() {
        return irrigationActionId;
    }

    public String getMaintenancePruningVinesActionId() {
        return maintenancePruningVinesActionId;
    }

    public boolean isPhytoEffect() {
        return phytoEffect;
    }

    public void setPhytoEffect(boolean phytoEffect) {
        this.phytoEffect = phytoEffect;
    }
}
