package fr.inra.agrosyst.services.pz0import.input;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PhytoProductInputImporter.java 5039 2015-07-15 09:48:17Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/input/PhytoProductInputImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.AbstractInput;
import fr.inra.agrosyst.api.entities.action.PhytoProductInput;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressor;
import fr.inra.agrosyst.api.entities.referential.RefBioAgressorTopiaDao;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.input.dto.PhytoProductInputDto;
import fr.inra.agrosyst.services.pz0import.input.model.PhytoProductInputModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 24/02/15.
 **/
public class PhytoProductInputImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PhytoProductInputImporter.class);

    protected RefBioAgressorTopiaDao refBioAgressorsDao;



    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(AbstractInput.class);

        PhytoProductInputModel model = new PhytoProductInputModel();
        // récupère le DTO
        Import<PhytoProductInputDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PhytoProductInputDto dto : importer) {

            boolean error = false;
            if (StringUtils.isNotBlank(dto.getTargets())) {
                RefBioAgressor bioAgressor = refBioAgressorsDao.forTopiaIdEquals(dto.getTargets()).findUniqueOrNull();
                if (bioAgressor == null) {
                    error = true;
                    importResults.addErrorLine(line, String.format("AJOUT DU BIO-AGRESSEUR CIBLÉ PAR L'INTRANT '%s' IGNORÉ!, le bio-agresseur avec comme identifiant '%s' n'a pas été retrouvé.", dto.getId(), dto.getTargets()));
                }

                EntityAndDependencies entityAndDependencies = entitiesByCsvId.get(dto.getId());
                if (entityAndDependencies != null) {
                    AbstractInput input = (AbstractInput) entityAndDependencies.getEntity();
                    if (input instanceof PhytoProductInput) {
                        if (bioAgressor != null) {
                            ((PhytoProductInput) input).addTargets(bioAgressor);
                        }
                    } else {
                        error = true;
                        importResults.addErrorLine(line, String.format("AJOUT DU BIO-AGRESSEUR CIBLÉ PAR L'INTRANT IGNORÉ!, l'intrant avec comme identifiant '%s' n'est pas un intrant phytosanitaire.", dto.getId()));
                    }
                } else {
                    error = true;
                    importResults.addErrorLine(line, String.format("AJOUT DU BIO-AGRESSEUR CIBLÉ PAR L'INTRANT IGNORÉ!, l'intrant avec comme identifiant '%s' n'a pas été retrouvé.", dto.getId()));
                }

                if (!error) {
                    importResults.increaseAddedRecords();
                    importResults.addInfoLine(line, ", " + String.format("AJOUT DU BIO-AGRESSEUR ciblé '%s' à l'intrant '%s' VALIDÉ", dto.getTargets(), dto.getId()));
                } else {
                    importResults.increaseIgnoredRecords();
                    importResults.addErrorLine(line, String.format("AJOUT DU BIO-AGRESSEUR ciblé '%s' à l'intrant '%s' IGNORÉ", dto.getTargets(), dto.getId()));
                }

            }

            line++;
        }
        return importResults;
    }

    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        refBioAgressorsDao = getPersistenceContext().getRefBioAgressorDao();
    }

}
