package fr.inra.agrosyst.services.pz0import.growingPlan;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GrowingPlanImportModel.java 5028 2015-07-10 06:33:13Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/growingPlan/GrowingPlanImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 *
 * @author Antoine Schellenberger
 */
class GrowingPlanImportModel extends AbstractAgrosystModelExtended<GrowingPlanImportDto> {

    public GrowingPlanImportModel() {
        super();

        newMandatoryColumn("topiaid", GrowingPlanImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", GrowingPlan.PROPERTY_CODE);
        newMandatoryColumn("domain", GrowingPlanImportDto.PROPERTY_DOMAIN_ID);
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", GrowingPlan.PROPERTY_NAME);
        newMandatoryColumn("description", GrowingPlan.PROPERTY_DESCRIPTION);
        newMandatoryColumn("goals", GrowingPlan.PROPERTY_GOALS);
        newMandatoryColumn("protocolreference", GrowingPlan.PROPERTY_PROTOCOL_REFERENCE);
        newMandatoryColumn("institutionalstructure", GrowingPlan.PROPERTY_INSTITUTIONAL_STRUCTURE);
        newMandatoryColumn("active", GrowingPlan.PROPERTY_ACTIVE, O_N_PARSER);
        newMandatoryColumn("validated", GrowingPlan.PROPERTY_VALIDATED, O_N_PARSER);
        newIgnoredColumn("validationdate");
        newMandatoryColumn("updatedate", GrowingPlan.PROPERTY_UPDATE_DATE, DATE_PARSER);
        newMandatoryColumn("type", "typeDEPHYImportValues");
    }

    @Override
    public GrowingPlanImportDto newEmptyInstance() {
        return new GrowingPlanImportDto();
    }


}
