package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GroundImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/GroundImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Ground;
import fr.inra.agrosyst.api.entities.GroundImpl;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalis;
import fr.inra.agrosyst.api.entities.referential.RefSolArvalisTopiaDao;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.DomainService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.GroundImportDto;
import fr.inra.agrosyst.services.pz0import.domain.model.GroundImportModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 05/05/15.
 */
public class GroundImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(GroundImporter.class);

    protected DomainService domainService;
    protected RefSolArvalisTopiaDao refSolArvalisDao;

    @Override
    public ImportResults importFromStream(InputStream is,  Map<String, EntityAndDependencies> domainAndDependancies) {

        ImportResults importResults = new ImportResults(Ground.class);

        GroundImportModel model = new GroundImportModel();
        Import<GroundImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (GroundImportDto dto : importer) {
            boolean error;

            Ground ground = new GroundImpl();

            ground.setName(dto.getName());
            ground.setImportance(dto.getImportance());
            ground.setComment(dto.getComment());

            error = addGroundToDomain(importResults, line, dto, ground, domainAndDependancies, false);

            error = validRefSolArvalis(dto, ground, importResults, line, error);

            error = validIsValidate(dto, ground, error);

            pz0IdToObject.put(ground.getClass(), dto.getId(), ground);
            if (!error) {
                importResults.addInfoLine(line, ", " + "SOL VALIDÉ , csvid: " + dto.getId() + ", il sera persistée avec le domaine: " + dto.getDomainId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "SOL IGNORÉE, csvid: " + dto.getId());
            }

            line++;
        }
        return  importResults;
    }

    protected boolean addGroundToDomain(ImportResults importResults, Long line, GroundImportDto dto, Ground ground, Map<String, EntityAndDependencies> domainAndDependancies, boolean error) {
        String domainId = dto.getDomainId();
        if (StringUtils.isNotBlank(domainId)) {
            DomainAndDependencies domainAndDependencies = (DomainAndDependencies) domainAndDependancies.get(domainId);
            if (domainAndDependencies != null) {
                pz0IdToObject.put(CroppingPlanEntryDto.class, DomainAndDependencies.class, dto.getId(), domainAndDependencies);
                domainAndDependencies.addGround(dto.getId(), ground);
            } else {
                error = true;
                importResults.addErrorLine(line, "SOL IGNORÉ, Le domain dont d'identifiant est:'" + domainId + "' n'a pas été retrouvé.");
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "SOL IGNORÉ, La colonne 'domain' n'est pas renseignée.");
        }
        return error;
    }

    protected boolean validRefSolArvalis(GroundImportDto from, Ground to, ImportResults importResults, long line, boolean error) {
        String value = from.getRefSolArvalisId();
        if (StringUtils.isNotBlank(value)) {
            RefSolArvalis refSolArvalis = refSolArvalisDao.forTopiaIdEquals(value).findUniqueOrNull();
            if (refSolArvalis != null) {
                to.setRefSolArvalis(refSolArvalis);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("SOL IGNORÉ ! la région avec comme identifiant %s n'a pu etre retrouvée !", value));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "SOL IGNORÉ, La colonne 'refsolarvalis' n'est pas renseignée.");
        }
        return error;
    }


    protected boolean validIsValidate(GroundImportDto from, Ground to, boolean error) {
        Boolean value = from.getValidated();
        if (value != null) {
            to.setValidated(value);
        } else {
            to.setValidated(true);
            // error = true;
            // importResults.addErrorLine(line, "SOL IGNORÉ, La colonne 'validated' n'est pas renseignée.");
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        domainService = getServiceFactory().newService(DomainService.class);
        refSolArvalisDao = getPersistenceContext().getRefSolArvalisDao();
    }

}
