package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EquipmentForToolsCouplingImporter.java 5059 2015-08-13 12:35:33Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/EquipmentForToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.EquipmentImpl;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.EquipmentForToolCoupling;
import fr.inra.agrosyst.services.pz0import.domain.model.EquipmentsToolsCouplingImportModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 09/12/14.
 */
public class EquipmentForToolsCouplingImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EquipmentForToolsCouplingImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EquipmentForToolCoupling.class);

        EquipmentsToolsCouplingImportModel model = new EquipmentsToolsCouplingImportModel();
        Import<EquipmentForToolCoupling> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (EquipmentForToolCoupling dto : importer) {

            ToolsCoupling toolsCoupling = null;
            if (StringUtils.isNotBlank(dto.getToolCouplingId())) {
                toolsCoupling = (ToolsCoupling) pz0IdToObject.get(ToolsCoupling.class, dto.getToolCouplingId());
                if (toolsCoupling == null) {
                    importResults.addErrorLine(line, String.format("AJOUT DE L'EQUIPEMENT %s A UN COMBINAISON D'OUTIL IGNORÉ, la combinaison d'outil avec comme identifiant %s n'a n'existe pas ! ", dto.getEquipmentId(), dto.getToolCouplingId()));
                }
            } else {
                importResults.addErrorLine(line, String.format("AJOUT DE L'EQUIPEMENT %s A UN COMBINAISON D'OUTIL IGNORÉ, colonne 'toolscoupling' non renseignée", dto.getEquipmentId()));
            }

            Equipment equipment = null;
            if (StringUtils.isNotBlank((dto.getEquipmentId()))) {
                equipment = (Equipment) pz0IdToObject.get(Equipment.class, dto.getEquipmentId());
                if (equipment == null || equipment.getRefMateriel() == null) {
                    importResults.addErrorLine(line, String.format("AJOUT DE L'EQUIPEMENT %s A UN COMBINAISON D'OUTIL IGNORÉ, cet équipement n'a pu être retrouvé !", dto.getEquipmentId()));
                } else {
                    if (StringUtils.contains(equipment.getRefMateriel().getTopiaId(),"RefMaterielAutomoteur") || StringUtils.contains(equipment.getRefMateriel().getTopiaId(),"RefMaterielTraction")) {
                        importResults.addErrorLine(line, String.format("MATERIEL IGNORÉ, l'équipement avec comme identifiant : %s, " +
                                "est un tracteur ou un automoteur et non un outil ! ",dto.getEquipmentId()));
                    }
                }
            } else {
                importResults.addErrorLine(line, String.format("AJOUT DE L'EQUIPEMENT %s A UN COMBINAISON D'OUTIL IGNORÉ, colonne 'equipments' non renseignée !", dto.getEquipmentId()));
            }

            if (toolsCoupling != null && equipment != null) {
                if (toolsCoupling.isManualIntervention()) {
                    importResults.addErrorLine(line, String.format("AJOUT DE L'EQUIPEMENT %s A UN COMBINAISON D'OUTIL IGNORÉ, l'équipement ne peut être ajouté à une intervention manuelle !", dto.getEquipmentId()));
                } else {

                    // to be able to save tools coupling it's necessary to have different object instance that the targeted one.
                    Equipment bindingEquipment = new EquipmentImpl();
                    Binder<Equipment, Equipment> tractorBinder = BinderFactory.newBinder(Equipment.class, Equipment.class);
                    tractorBinder.copy(equipment, bindingEquipment);

                    toolsCoupling.addEquipments(bindingEquipment);
                    importResults.addInfoLine(line, ", " + String.format("EQUIPEMENT %s AJOUTÉ à la combinaison d'outil %s", dto.getEquipmentId(), dto.getToolCouplingId()));
                    importResults.increaseAddedRecords();
                }

            } else {
                importResults.increaseIgnoredRecords();
            }

            line++;
        }
        return  importResults;
    }
}
