package fr.inra.agrosyst.services.pz0import.action.harvestingYeald;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: HarvestingYealdImporter.java 5036 2015-07-10 21:45:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.5.1/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/harvestingYeald/HarvestingYealdImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.action.HarvestingYealdImpl;
import fr.inra.agrosyst.api.entities.action.YealdCategory;
import fr.inra.agrosyst.api.entities.action.YealdUnit;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 12/02/15.
 */
public class HarvestingYealdImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(HarvestingYealdImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(HarvestingYeald.class);

        HarvestingYealdModel model = new HarvestingYealdModel();
        // récupère le DTO
        Import<HarvestingYealdImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (HarvestingYealdImportDto dto : importer) {
            boolean error;

            // valid required fields
            error = validHarvestingAction(importResults, line, dto, false);

            error = validHarvestingYealdCategory(importResults, line, dto, error);

            error = validYealdAverage(importResults, line, dto, error);

            error = validYealdUnit(importResults, line, dto, error);

            if (!error) {
                HarvestingYeald harvestingYeald = new HarvestingYealdImpl();
                Binder<HarvestingYealdImportDto, HarvestingYeald> binder = BinderFactory.newBinder(HarvestingYealdImportDto.class, HarvestingYeald.class);
                binder.copy(dto, harvestingYeald);
                HarvestingAction harvestingAction = (HarvestingAction)pz0IdToObject.get(AbstractAction.class, dto.getHarvestingActionId());
                harvestingAction.addHarvestingYealds(harvestingYeald);

                importResults.addInfoLine(line, ", " + "AJOUT DU RENDEMENT DE RÉCOLTE VALIDÉ");
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ");
            }
            line++;
        }
        return importResults;
    }

    protected boolean validHarvestingAction(ImportResults importResults, long line, HarvestingYealdImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getHarvestingActionId())) {
            HarvestingAction harvestingAction = (HarvestingAction)pz0IdToObject.get(AbstractAction.class, from.getHarvestingActionId());
            if (harvestingAction == null) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, L'action de récolte avec l'identifiant %s n'a pas été retrouvé.", from.getHarvestingActionId()));
            } else {
                AgrosystInterventionType actionType = ((AbstractAction)pz0IdToObject.get(AbstractAction.class, from.getHarvestingActionId())).getMainAction().getIntervention_agrosyst();
                if (!actionType.equals(AgrosystInterventionType.RECOLTE)) {
                    error = true;
                    importResults.addErrorLine(line, String.format("AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, L'action suivante n'est pas une action de récolte : %s", from.getHarvestingActionId()));
                }
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, La colonne 'harvestingaction' doit être renseignée.");
        }

        return error;
    }

    protected boolean validHarvestingYealdCategory(ImportResults importResults, long line, HarvestingYealdImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getYealdCategoryName())) {
            try{
                YealdCategory yealdCategory = YealdCategory.valueOf(from.getYealdCategoryName());
                from.setYealdCategory(yealdCategory);
            } catch (IllegalArgumentException e) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, Categotie de rendemant incorrect %s.", from.getYealdCategoryName()));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, La colonne 'yealdcategory' doit être renseignée.");
        }

        return error;
    }

    protected boolean validYealdAverage(ImportResults importResults, long line, HarvestingYealdImportDto from, boolean error) {

        if (from.getYealdAverageWithNull() != null) {
            from.setYealdAverage(from.getYealdAverageWithNull());
        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, La colonne 'yealdaverage' doit être renseignée.");
        }

        return error;
    }

    protected boolean validYealdUnit(ImportResults importResults, long line, HarvestingYealdImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getYealdUnitName())) {
            try{
                YealdUnit unit = YealdUnit.valueOf(from.getYealdUnitName());
                from.setYealdUnit(unit);
            } catch (IllegalArgumentException e) {
                error = true;
                importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, unitée de rendement non reconnue.");
            }

        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DU RENDEMENT DE RÉCOLTE IGNORÉ!, La colonne 'yealdunit' doit être renseignée.");
        }

        return error;
    }

}
