package fr.inra.agrosyst.services.pz0import.zone;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: ZoneImportModel.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/zone/ZoneImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 25/03/15.
 */
public class ZoneImportModel extends AbstractAgrosystModelExtended<ZoneDto> {


    protected ZoneImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("plot", "plot");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", "name");
        newMandatoryColumn("area", "area", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("latitude", "latitude" , DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("longitude", "longitude", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("comment", "comment");
        newMandatoryColumn("active", "active", T_F_PARSER);
        newMandatoryColumn("type", "type");
    }

    @Override
    public ZoneDto newEmptyInstance() {
        return new ZoneDto();
    }


}
