package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedPerennialCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedPerennialCropCycleImportModel.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedPerennialCropCycle/PracticedPerennialCropCycleImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 25/03/15.
 */
public class PracticedPerennialCropCycleImportModel extends AbstractAgrosystModelExtended<PracticedPerennialCropCycleImportDto> {

    protected PracticedPerennialCropCycleImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newMandatoryColumn("plantingyear", "plantingYear", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantinginterfurrow", "plantingInterFurrow", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingspacing", "plantingSpacing", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdensity", "plantingDensity", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdeathrate", "plantingDeathRate", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("plantingdeathratemeasureyear", "plantingDeathRateMeasureYear", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("croppingplanentrycode", "croppingPlanEntryCode");
        newMandatoryColumn("pollinator", "pollinator", T_F_PARSER);
        newMandatoryColumn("pollinatorpercent", "pollinatorPercent", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("pollinatorspreadmode", "pollinatorSpreadMode");
        newMandatoryColumn("othercharacteristics", "otherCharacteristics");
        newMandatoryColumn("orchardfrutalform", "orchardFrutalForm");
        newMandatoryColumn("vinefrutalform", "vineFrutalForm");
        newMandatoryColumn("orientation", "orientation");
        newMandatoryColumn("weedtype", "weedType");
        newMandatoryColumn("growingsystemportion", "solOccupationPercent", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("foliageheight","foliageHeight", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("foliagethickness", "foliageThickness", DOUBLE_WITH_NULL_AND_9999_PARSER);
    }

    @Override
    public PracticedPerennialCropCycleImportDto newEmptyInstance() {
        return new PracticedPerennialCropCycleImportDto();
    }
}
