package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleNodeImporter.java 4914 2015-04-30 08:10:37Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycleNode/PracticedCropCycleNodeImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Sets;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCycleNode;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedSeasonalCropCycle;
import fr.inra.agrosyst.services.common.CommonService;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.PracticedSystemImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle.PracticedCropCycleImportDto;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;

/**
 * Created by davidcosse on 04/02/15.
 */
public class PracticedCropCycleNodeImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycleNodeImporter.class);
    public static final String NEW_NODE = "new-node-";

    public static DomainAndDependencies getDomainAndDependenciesFromNode(String practicedSeasonalCropCycleId) {
        DomainAndDependencies domainAndDependencies = null;
        PracticedSystemAndDependencies practicedSystemAndDependencies = getSeasonalCropCycleRelatedPracticedSystem(practicedSeasonalCropCycleId);
        if (practicedSystemAndDependencies != null) {
            domainAndDependencies = PracticedSystemImporter.getDomainAndDependanciesFromPracticedSystem(practicedSystemAndDependencies.getPracticedSystem());
        }
        return domainAndDependencies;
    }

    public static PracticedSystemAndDependencies getSeasonalCropCycleRelatedPracticedSystem(String practicedSeasonalCropCycleId) {
        PracticedSystemAndDependencies practicedSystemAndDependencies = null;
        if (StringUtils.isNotBlank(practicedSeasonalCropCycleId)) {
            practicedSystemAndDependencies = getPracticedSystemFromPracticedSeasonalCropId(practicedSeasonalCropCycleId);
        }
        return practicedSystemAndDependencies;
    }

    protected static PracticedSystemAndDependencies getPracticedSystemFromPracticedSeasonalCropId(String practicedSeasonalCropCycleId) {
        PracticedSystemAndDependencies practicedSystemAndDependencies = null;
        if (StringUtils.isNotBlank(practicedSeasonalCropCycleId)) {
            PracticedCropCycleImportDto practicedCropCycleImportDto = (PracticedCropCycleImportDto) pz0IdToObject.get(PracticedCropCycle.class, practicedSeasonalCropCycleId);
            if (practicedCropCycleImportDto != null) {
                practicedSystemAndDependencies = (PracticedSystemAndDependencies) pz0IdToObject.get(PracticedSystem.class, practicedCropCycleImportDto.getPracticedSystemId());
            }
        }
        return practicedSystemAndDependencies;
    }

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycleNode.class);

        PracticedCropCycleNodeImportModel model = new PracticedCropCycleNodeImportModel();
        // récupère le DTO
        Import<PracticedCropCycleNodeImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleNodeImportDto dto : importer) {
            boolean error = false;

            Pz0PracticedCropCycleNode pz0PracticedCropCycleNode = new Pz0PracticedCropCycleNode(dto.getId(), dto.getPracticedSeasonalCropCycleId());
            PracticedCropCycleNodeDto cropCycleNode = pz0PracticedCropCycleNode.getNodeDto();
            Binder<PracticedCropCycleNodeImportDto, PracticedCropCycleNodeDto> binder = BinderFactory.newBinder(PracticedCropCycleNodeImportDto.class, PracticedCropCycleNodeDto.class);
            binder.copy(dto, cropCycleNode);

            // valid required fields
            error = validSeasonalPracticedSystemAffiliationAndAddNodeToIt(importResults, line, dto, error);

            error = validNodeCrop(importResults, line, dto, cropCycleNode, error);

            addNodeToCycle(dto, cropCycleNode);
            String newNodeId = NEW_NODE + dto.getId();
            cropCycleNode.setNodeId(newNodeId);
            pz0IdToObject.put(Pz0PracticedCropCycleNode.class,  dto.getId(), pz0PracticedCropCycleNode);
            if (!error) {
                importResults.addInfoLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ VALIDÉ, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSeasonalPracticedSystemAffiliationAndAddNodeToIt(ImportResults importResults, long line, PracticedCropCycleNodeImportDto from, boolean error) {
        String practicedSeasonalCropCycleId = from.getPracticedSeasonalCropCycleId();

        if (StringUtils.isNotBlank(practicedSeasonalCropCycleId)) {
            Pz0PracticedSeasonalCropCycle pz0SeasonalCropCycle = (Pz0PracticedSeasonalCropCycle) pz0IdToObject.get(Pz0PracticedSeasonalCropCycle.class,practicedSeasonalCropCycleId);
            if (pz0SeasonalCropCycle == null) {
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, le system synthétisé n'a pu être retrouvé.");
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'practicedseasonalcropcycle' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    protected void addNodeToCycle(PracticedCropCycleNodeImportDto dto, PracticedCropCycleNodeDto cycleNodeDto) {
        String practicedSeasonalCropCycleId = dto.getPracticedSeasonalCropCycleId();
        Pz0PracticedSeasonalCropCycle pz0SeasonalCropCycle = (Pz0PracticedSeasonalCropCycle) pz0IdToObject.get(Pz0PracticedSeasonalCropCycle.class,practicedSeasonalCropCycleId);
        pz0SeasonalCropCycle.getPracticedSeasonalCropCycleDto().addNode(cycleNodeDto);
    }

    protected boolean validNodeCrop(ImportResults importResults, long line, PracticedCropCycleNodeImportDto from, PracticedCropCycleNodeDto to, boolean error) {
            String cropCode = from.getCroppingPlanEntryCode();
            if (StringUtils.isNotBlank(cropCode)) {
                DomainAndDependencies domainAndDependencies = getDomainAndDependenciesFromNode(from.getPracticedSeasonalCropCycleId());
                if (domainAndDependencies != null) {
                    PracticedSystemAndDependencies practicedSystemAndDependencies = getPracticedSystemFromPracticedSeasonalCropId(from.getPracticedSeasonalCropCycleId());
                    if (practicedSystemAndDependencies != null && StringUtils.isNotBlank(practicedSystemAndDependencies.getPracticedSystem().getCampaigns())) {
                        Set<Integer> campaigns = CommonService.GET_CAMPAIGNS_SET.apply(practicedSystemAndDependencies.getPracticedSystem().getCampaigns());
                        Set<String> cropCodes = Sets.newHashSet();

                        if (campaigns != null) {
                            for (Integer campaign : campaigns) {
                                Set<String> domainCropcodesForCampaign = domainCodeCampaignCropCode.get(domainAndDependencies.getCsvCode(), campaign);
                                if (CollectionUtils.isNotEmpty(domainCropcodesForCampaign)) {
                                    cropCodes.addAll(domainCropcodesForCampaign);
                                }
                            }
                        } else {
                            importResults.addErrorLine(line, String.format("NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, les campagnes suivante '%s', ne permettent pas de retrouver le domaine de la culture avec comme code %s.", practicedSystemAndDependencies.getPracticedSystem().getCampaigns(), cropCode));
                            error = true;
                        }

                        if (!cropCodes.isEmpty()) {
                            if (cropCodes.contains(cropCode)) {
                                String agrosystCode = pz0CodeToAgrosystCode.get(CroppingPlanEntryDto.class, cropCode);
                                to.setCroppingPlanEntryCode(agrosystCode);
                            } else {
                                importResults.addErrorLine(line, String.format("NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la culture ayant pour code '%s' n'a pu être retrouvée sur les domaines ayant pour code '%s' pour les campagnes suivantes: %s pour le noeud dont l'identifiant est: %s.", cropCode, domainAndDependencies.getCsvCode(), practicedSystemAndDependencies.getPracticedSystem().getCampaigns(), from.getId()));
                                error = true;
                            }
                        } else {
                            importResults.addErrorLine(line, String.format("NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, aucune culture n'existe pour les domaines ayant pour code '%s' pour les campagnes suivantes: %s.", domainAndDependencies.getCsvCode(), practicedSystemAndDependencies.getPracticedSystem().getCampaigns()));
                            error = true;
                        }

                    } else {
                        importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, le système synthétisé n'a pu être retrouvé, ou ses campagnes ne sont pas renseigné, impossible de validé l'affiliation de la culture");
                        error = true;
                    }
                } else {
                    importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, domaine non retrouvé pour la culture du noeud " + from.getId());
                    error = true;
                }

            } else {
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'croppingplanentrycode' n'est pas rensigné !" + from.getId());
                error = true;
            }

        return error;
    }

}
