package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleImporter.java 4914 2015-04-30 08:10:37Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycle/PracticedCropCycleImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 03/02/15.
 */
public class PracticedCropCycleImporter extends AbstractCSVImporter {

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycle.class);

        PracticedCropCycleImportModel model = new PracticedCropCycleImportModel();
        // récupère le DTO
        Import<PracticedCropCycleImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleImportDto dto : importer) {
            boolean error = false;

            // valid required fields
            error = validPracticedSystemAffiliation(importResults, line, dto, entitiesByCsvId, error);

            pz0IdToObject.put(PracticedCropCycle.class,  dto.getId(), dto);
            if (!error) {
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validPracticedSystemAffiliation(ImportResults importResults, long line, PracticedCropCycleImportDto dto, Map<String, EntityAndDependencies> entityAndDependenciesMap, boolean error) {
        String target = dto.getPracticedSystemId();
        if (StringUtils.isNotBlank(target)) {
            EntityAndDependencies practicedSystemAndDependencies = entityAndDependenciesMap.get(target);
            if (practicedSystemAndDependencies == null) {
                importResults.addErrorLine(line, String.format("CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, aucun système pratiqué n'est retrouvée avec l'identifiant suivant: %s", target));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'practicedsystem' n'est pas renseignée !");
            error = true;
        }
        return error;
    }

}
