package fr.inra.agrosyst.services.pz0import.practicedSystem.PracticedPerennialCropCyclePhase;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedPerennialCropCyclePhaseImporter.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/PracticedPerennialCropCyclePhase/PracticedPerennialCropCyclePhaseImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.CropCyclePhaseType;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhase;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCyclePhaseImpl;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedCropCyclePhase;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.Pz0PracticedPerennialCropCycle;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 26/03/15.
 */
public class PracticedPerennialCropCyclePhaseImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCyclePhaseDto.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCyclePhaseDto.class);

        PracticedPerennialCropCyclePhaseImportModel model = new PracticedPerennialCropCyclePhaseImportModel();
        // récupère le DTO
        Import<PracticedPerennialCropCyclePhaseImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedPerennialCropCyclePhaseImportDto dto : importer) {
            boolean error = false;

            // PracticedSystem required to map PracticedCropCyclePhase to PracticedCropCyclePhaseDto
            Pz0PracticedCropCyclePhase pz0Phase = new Pz0PracticedCropCyclePhase(dto.getId(), dto.getPracticedPerennialCropCycle());
            PracticedCropCyclePhaseDto phaseDto = pz0Phase.getPhaseDto();
            PracticedCropCyclePhase practicedCropCyclePhase = new PracticedCropCyclePhaseImpl();

            // set optional duration
            practicedCropCyclePhase.setDuration(dto.getDuration());

            // valid required fields
            error = validPracticedPerennialCropCycleAffiliation(importResults, line, dto, pz0Phase, error);

            // required enum
            error = validType(importResults, line, dto, phaseDto, error);

            pz0IdToObject.put(Pz0PracticedCropCyclePhase.class, dto.getId(), pz0Phase);
            if (!error) {
                importResults.addInfoLine(line, "PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ VALIDÉE, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ IGNORÉE csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validPracticedPerennialCropCycleAffiliation(ImportResults importResults, long line, PracticedPerennialCropCyclePhaseImportDto dto,Pz0PracticedCropCyclePhase pz0Phase, boolean error) {
        String target = dto.getPracticedPerennialCropCycle();
        if (StringUtils.isNotBlank(target)) {
            Pz0PracticedPerennialCropCycle cycle = (Pz0PracticedPerennialCropCycle) pz0IdToObject.get(Pz0PracticedPerennialCropCycle.class, target);
            if (cycle == null) {
                importResults.addErrorLine(line, String.format("PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ IGNORÉE!, aucun cycle de culture pérenne retrouvé avec l'identifiant suivant: %s", target));
                error = true;
            } else {
                cycle.addPz0Phase(pz0Phase);
            }
        } else {
            importResults.addErrorLine(line, "PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'practicedperennialcropcycle' n'est pas renseignée");
            error = true;
        }
        return error;
    }

    protected boolean validType(ImportResults importResults, long line, PracticedPerennialCropCyclePhaseImportDto dto, PracticedCropCyclePhaseDto phaseDto, boolean error) {
        String typeSt = dto.getType();
        if (StringUtils.isNotBlank(typeSt)) {
            try {
                CropCyclePhaseType type = CropCyclePhaseType.valueOf(typeSt);
                phaseDto.setType(type);
            } catch (IllegalArgumentException e) {
                importResults.addErrorLine(line, String.format("PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ IGNORÉE!, le type de phase '%s' n'est pas reconnu pour la phase d'id: %s", typeSt, dto.getId()));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "PHASE DU CYCLE DE CULTURE PÉRENNE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'type' n'est pas renseignée");
            error = true;
        }
        return error;
    }

}
