package fr.inra.agrosyst.services.pz0import.growingSystem;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GrowingSystemNetworkImporter.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/growingSystem/GrowingSystemNetworkImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Network;
import fr.inra.agrosyst.api.entities.NetworkTopiaDao;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.growingSystem.GrowingSystemAndDependencies;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;


public class GrowingSystemNetworkImporter extends AbstractCSVImporter {

    protected NetworkTopiaDao networkDao;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> growingSystemAndDependenciesByCsvId) {

        ImportResults importResults = new ImportResults(GrowingSystemNetworkImporter.class);

        GrowingSystemNetworkImportModel model = new GrowingSystemNetworkImportModel();

        // récupère le DTO
        Import<GrowingSystemNetworkImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        long line = FIRST_LINE_NUMBER;
        for (GrowingSystemNetworkImportDto dto : importer) {
            boolean error = false;

            GrowingSystemAndDependencies growingSystemAndDependencies = null;
            Network network;

            String growingSystemId = dto.getGrowingSystemId();
            if (StringUtils.isNotBlank(growingSystemId)) {
                growingSystemAndDependencies = (GrowingSystemAndDependencies) growingSystemAndDependenciesByCsvId.get(growingSystemId);
                if (growingSystemAndDependencies == null) {
                    error = true;
                    importResults.addErrorLine(line, String.format("LE SYSTÈME DE CULTURE AVEC COMME ID %s N'A PAS ÉTÉ RETROUVÉ", growingSystemId));
                }
            } else {
                error = true;
                importResults.addErrorLine(line, "la colonne 'growingsystem' n'est pas renseignée");
            }


            String networkId = dto.getNetworkId();
            if (StringUtils.isNotBlank(networkId)) {
                network = networkDao.forTopiaIdEquals(networkId).findUniqueOrNull();
                if (network == null) {
                    error = true;
                    importResults.addErrorLine(line, String.format("LE RÉSEAU AVEC COMME ID %s N'A PAS ÉTÉ RETROUVÉ", networkId));
                }
            } else {
                error = true;
                importResults.addErrorLine(line, "la colonne 'networks' n'est pas renseignée");
            }

            if (!error) {
                importResults.addInfoLine(line, String.format("APPAIRAGE DU RÉSEAU %s AVEC LE SYSTÈME DE CULTURE %s VALIDÉ", networkId, growingSystemId));
                importResults.increaseAddedRecords();
                growingSystemAndDependencies.addNetworkToGrowingSystem(networkId);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "ECHEC D'APPAIRAGE D'UN RÉSEAU AVEC UN SYSTÈME DE CULTURE");
            }

            line++;
        }


        return importResults;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        networkDao = getPersistenceContext().getNetworkDao();
    }

}
