package fr.inra.agrosyst.services.pz0import.effective.effectiveSeasonalCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveSeasonalCropCycleImporter.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveSeasonalCropCycle/EffectiveSeasonalCropCycleImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Zone;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.effective.EffectiveCropCycleAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.services.pz0.plot.PlotAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 02/04/15.
 */
public class EffectiveSeasonalCropCycleImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectiveSeasonalCropCycleImporter.class);
    
    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectiveSeasonalCropCycleDto.class);
        log.debug("importfromstream");

        EffectiveSeasonalCropCycleImportModel model = new EffectiveSeasonalCropCycleImportModel();

        Import<fr.inra.agrosyst.services.pz0import.effective.effectiveSeasonalCropCycle.EffectiveSeasonalCropCycleImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (fr.inra.agrosyst.services.pz0import.effective.effectiveSeasonalCropCycle.EffectiveSeasonalCropCycleImportDto dto : importer) {
            boolean error = false;

            Pz0EffectiveSeasonalCropCycle effectiveSeasonalCropCycleDto = new Pz0EffectiveSeasonalCropCycle(dto.getId());
            EffectiveSeasonalCropCycleDto getSeasonalCropCycle = effectiveSeasonalCropCycleDto.getSeasonalCropCycle();

            // EffectivePerennialCropCycle to persist
            Binder<EffectiveSeasonalCropCycleImportDto, EffectiveSeasonalCropCycleDto> binder = BinderFactory.newBinder(EffectiveSeasonalCropCycleImportDto.class, EffectiveSeasonalCropCycleDto.class);
            binder.copyExcluding(dto, getSeasonalCropCycle,
                    EffectiveSeasonalCropCycleDto.PROPERTY_TOPIA_ID);

            // valid required related objects

            error = validZoneAffiliation(importResults, line, dto, error);

            stock(dto, effectiveSeasonalCropCycleDto);

            if (!error) {
                importResults.addInfoLine(line, "CYCLE DE CULTURE DU RÉALISÉ VALIDÉ, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CYCLE DE CULTURE DU RÉALISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected void stock(EffectiveSeasonalCropCycleImportDto dto, Pz0EffectiveSeasonalCropCycle effectiveSeasonalCropCycleDto) {
        EffectiveCropCycleAndDependencies effectiveCropCycleAndDependencies = getEffectiveCropCycleAndDependencies(dto.getZoneId());

        if (effectiveCropCycleAndDependencies != null) {
            effectiveCropCycleAndDependencies.addEffectiveSeasonalCropCycleDto(dto.getId(), effectiveSeasonalCropCycleDto);
            pz0IdToObject.put(EffectiveSeasonalCropCycleDto.class, EffectiveCropCycleAndDependencies.class, dto.getId(), effectiveCropCycleAndDependencies);
        }
        pz0IdToObject.put(Pz0EffectiveSeasonalCropCycle.class, dto.getId(), effectiveSeasonalCropCycleDto);
    }


    protected boolean validZoneAffiliation(ImportResults importResults, long line, fr.inra.agrosyst.services.pz0import.effective.effectiveSeasonalCropCycle.EffectiveSeasonalCropCycleImportDto dto, boolean error) {
        String target = dto.getZoneId();
        if (StringUtils.isNotBlank(target)) {
            PlotAndDependencies plotAndDependencies = (PlotAndDependencies) pz0IdToRelatedObjectId.get(Zone.class, PlotAndDependencies.class, target);
            if (plotAndDependencies == null) {
                importResults.addErrorLine(line, String.format("CYCLE DE CULTURE SAISONNIÈRE DU RÉALISÉ IGNORÉ!, aucune zone n'est retrouvée avec l'identifiant suivant: %s", target));
                error = true;
            }

        } else {
            importResults.addErrorLine(line, "CYCLE DE CULTURE SAISONNIÈRE DU RÉALISÉ IGNORÉ!, la colonne 'zone' n'est pas renseignée");
            error = true;
        }
        return error;
    }
}
