package fr.inra.agrosyst.services.pz0import.effective.effectiveCropCycleConnection;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveCropCycleConnectionImporter.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/effectiveCropCycleConnection/EffectiveCropCycleConnectionImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.EffectiveCropCycleAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveCropCycleNode;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 02/04/15.
 */
public class EffectiveCropCycleConnectionImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(EffectiveCropCycleConnectionImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(EffectiveCropCycleConnectionDto.class);
        log.debug("importfromstream");

        EffectiveCropCycleConnectionImportModel model = new EffectiveCropCycleConnectionImportModel();

        Import<EffectiveCropCycleConnectionImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (EffectiveCropCycleConnectionImportDto dto : importer) {
            boolean error = false;

            EffectiveCropCycleConnectionDto connectionDto = new EffectiveCropCycleConnectionDto();
            Pz0EffectiveSeasonalCropCycle pz0SeasonalCropCycle = getCycle(dto);

            // valid required related objects
            error = validTarget(importResults, line, pz0SeasonalCropCycle, dto, connectionDto, error);
            error = validIntermediateCrops(importResults, line, dto, connectionDto, error);

            // valid not required related objects
            error = validSource(importResults, line, pz0SeasonalCropCycle, dto, connectionDto, error);

            error = validNotReversedConnexion(importResults, line, dto, error);

            pz0SeasonalCropCycle.getSeasonalCropCycle().addConnectionDto(connectionDto);
            // need to be able to find it out EffectiveCropCycleNodeDto to add phase ont it
            pz0IdToObject.put(EffectiveCropCycleConnectionDto.class, dto.getId(), connectionDto);

            if (!error) {
                importResults.addInfoLine(line, "CONNEXION DU RÉALISÉ VALIDÉE, csvid: " + dto.getId());
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CONNEXION DU RÉALISÉ IGNORÉE csvid:" + dto.getId());
            }


            line++;
        }
        return importResults;
    }

    private boolean validNotReversedConnexion(ImportResults importResults, long line, EffectiveCropCycleConnectionImportDto dto, boolean error) {
        String sourceId = dto.getSourceId();
        String targetId = dto.getTargetId();
        if (StringUtils.isNotBlank(sourceId) && StringUtils.isNotBlank(targetId)) {
            Pz0EffectiveCropCycleNode pz0NodeSource = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, sourceId);
            Pz0EffectiveCropCycleNode pz0NodeTarget = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, targetId);
            if (pz0NodeTarget != null && pz0NodeSource != null) {
                if (pz0NodeSource.getNode().getRank() >= pz0NodeTarget.getNode().getRank()) {
                    importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, la connexion a pour cible un noeud d'un rang inférieur ou égal au noeud source: %s", targetId));
                    error = true;
                }
            }
        }
        return error;
    }

    protected boolean validTarget(ImportResults importResults, long line, Pz0EffectiveSeasonalCropCycle cycle, EffectiveCropCycleConnectionImportDto dto, EffectiveCropCycleConnectionDto connection, boolean error) {
        String targetId = dto.getTargetId();
        if (StringUtils.isNotBlank(targetId)) {
            Pz0EffectiveCropCycleNode pz0NodeTarget = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, targetId);
            if (pz0NodeTarget != null) {
                connection.setTargetId(pz0NodeTarget.getNode().getNodeId());
                pz0NodeTarget.setTargetId(targetId);

                if (!cycle.validNodeUniqueTargetConstraint(dto.getTargetId())) {
                    importResults.addErrorLine(line, "CONNEXION DU RÉALISÉ IGNORÉE!, le noeud cible a déjà une connexion cible");
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, aucun noeud cible n'est retrouvé avec l'identifiant suivant: %s", targetId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CONNEXION DU RÉALISÉ IGNORÉE!, la colonne 'target' n'est pas renseignée");
            error = true;
        }
        return error;
    }

    protected boolean validSource(ImportResults importResults, long line, Pz0EffectiveSeasonalCropCycle cycle, EffectiveCropCycleConnectionImportDto dto, EffectiveCropCycleConnectionDto connection,  boolean error) {
        String sourceId = dto.getSourceId();
        if (StringUtils.isNotBlank(sourceId)) {
            Pz0EffectiveCropCycleNode pz0NodeSource = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, sourceId);
            if (pz0NodeSource != null) {
                connection.setSourceId(pz0NodeSource.getNode().getNodeId());
                pz0NodeSource.setSourceId(sourceId);

                if (!cycle.validNodeUniqueSourceConstraint(dto.getSourceId())) {
                    importResults.addErrorLine(line, "CONNEXION DU RÉALISÉ IGNORÉE!, le noeud source a déjà une connexion source");
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, aucun noeud source n'est retrouvé avec l'identifiant suivant: %s", sourceId));
                error = true;
            }
        }
        return error;
    }

    protected boolean validIntermediateCrops(ImportResults importResults, long line, EffectiveCropCycleConnectionImportDto dto, EffectiveCropCycleConnectionDto cycleConnectionDto, boolean error) {
        String cropId = dto.getIntermediateCroppingPlanEntryId();
        if (StringUtils.isNotBlank(cropId) && !error) {
            try {
                // find cycle to get zone to get domain's crop
                EffectiveCropCycleAndDependencies cycleAndDependencies = getCycleAndDependencies(dto);
                DomainAndDependencies domainAndDependencies = cycleAndDependencies.getDomainAndDependencies();

                if (domainAndDependencies != null) {
                    Map<String, CroppingPlanEntryDto> cropIds = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId();
                    if (cropIds != null) {
                        if (cropIds.get(cropId) != null){
                            cycleConnectionDto.setIntermediateCroppingPlanEntryId(cropId);
                        } else {
                            error = true;
                            importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, la culture avec comme identifiant:%s n'a pas été retrouvée sur le domaine %s", cropId, domainAndDependencies.getCsvId()));
                        }
                    } else {
                        error = true;
                        importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, la culture avec comme identifiant:%s n'a pas été retrouvée sur le domaine %s", cropId, domainAndDependencies.getCsvId()));
                    }
                } else {
                    error = true;
                    importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, le domaine associé à la zone %s n'a pu être retrouvé", dto.getId()));
                }

            } catch (NullPointerException e) {
                error = true;
                importResults.addErrorLine(line, String.format("CONNEXION DU RÉALISÉ IGNORÉE!, la culture avec comme identifiant:%s n'a pas été retrouvée", cropId));
            }

        }
        return  error;
    }

    private EffectiveCropCycleAndDependencies getCycleAndDependencies(EffectiveCropCycleConnectionImportDto dto) {
        Pz0EffectiveCropCycleNode targetImported = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, dto.getTargetId());
        return (EffectiveCropCycleAndDependencies) pz0IdToObject.get(EffectiveSeasonalCropCycleDto.class, EffectiveCropCycleAndDependencies.class, targetImported.getEffectiveSeasonalCropCycleId());
    }

    protected Pz0EffectiveSeasonalCropCycle getCycle(EffectiveCropCycleConnectionImportDto dto) {
        Pz0EffectiveCropCycleNode nodeImportDto = (Pz0EffectiveCropCycleNode) pz0IdToObject.get(Pz0EffectiveCropCycleNode.class, dto.getTargetId());
        return (Pz0EffectiveSeasonalCropCycle) pz0IdToObject.get(Pz0EffectiveSeasonalCropCycle.class, nodeImportDto.getEffectiveSeasonalCropCycleId());
    }

}
