package fr.inra.agrosyst.services.pz0import.effective;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EffectiveCropCycleImporter.java 4923 2015-05-05 15:53:56Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/effective/EffectiveCropCycleImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.domain.CroppingPlanSpeciesDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleNodeDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.effective.EffectiveCropCycleSpeciesDto;
import fr.inra.agrosyst.api.services.effective.EffectiveInterventionDto;
import fr.inra.agrosyst.api.services.effective.EffectivePerennialCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.EffectiveCropCycleAndDependencies;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectivePerennialCropCycle;
import fr.inra.agrosyst.api.services.pz0.effective.Pz0EffectiveSeasonalCropCycle;
import fr.inra.agrosyst.api.services.pz0.plot.PlotAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Collection;
import java.util.Map;

/**
 * Created by davidcosse on 14/04/15.
 */
public class EffectiveCropCycleImporter {

    public Collection<EffectiveCropCycleAndDependencies> getEffectiveCropCycleAndDependencies() {
        Collection<EffectiveCropCycleAndDependencies> result = AbstractCSVImporter.getEffectiveCropCycleAndDependenciesByZone().values();
        return result;
    }

    public Collection<EffectiveCropCycleAndDependencies> propagateTopiaIdAndGetAllEffectiveCropCycleAndDependencies() {
        Collection<EffectiveCropCycleAndDependencies> effectiveCropCyclesAndDependencies = AbstractCSVImporter.getEffectiveCropCycleAndDependenciesByZone().values();
        for (EffectiveCropCycleAndDependencies effectiveCropCycleAndDependencies : effectiveCropCyclesAndDependencies) {
            DomainAndDependencies domainAndDependencies = effectiveCropCycleAndDependencies.getDomainAndDependencies();

            setCycleZoneId(effectiveCropCycleAndDependencies);

            propagateTopiaIdToPerennialCropCycles(effectiveCropCycleAndDependencies, domainAndDependencies);

            propagateTopiaIdToSeasonalCropCycles(effectiveCropCycleAndDependencies, domainAndDependencies);

        }
        return effectiveCropCyclesAndDependencies;
    }

    protected void setCycleZoneId(EffectiveCropCycleAndDependencies effectiveCropCycleAndDependencies) {
        PlotAndDependencies plotAndDependencies = AbstractCSVImporter.getPlotAndDependenciesForZone(effectiveCropCycleAndDependencies.getZoneId());
        effectiveCropCycleAndDependencies.setZoneId(plotAndDependencies.getZones().get(effectiveCropCycleAndDependencies.getZoneId()).getTopiaId());
    }

    protected void propagateTopiaIdToSeasonalCropCycles(EffectiveCropCycleAndDependencies effectiveCropCycleAndDependencies, DomainAndDependencies domainAndDependencies) {
        Map<String, CroppingPlanEntryDto> cropIds = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId();

        Map<String, Pz0EffectiveSeasonalCropCycle> effectivePz0SeasonalCropCycleMap = effectiveCropCycleAndDependencies.getEffectivePz0SeasonalCropCyclesByCsvId();
        if (effectivePz0SeasonalCropCycleMap != null) {
            for(Pz0EffectiveSeasonalCropCycle pz0EffectiveSeasonalCropCycle : effectivePz0SeasonalCropCycleMap.values()) {

                propagateTopiaIdToNodes(domainAndDependencies, cropIds, pz0EffectiveSeasonalCropCycle);
                propagateTopiaIdToConnections(cropIds, pz0EffectiveSeasonalCropCycle);

            }
        }
    }

    protected void propagateTopiaIdToConnections(Map<String, CroppingPlanEntryDto> cropIds, Pz0EffectiveSeasonalCropCycle pz0EffectiveSeasonalCropCycle) {
        Collection<EffectiveCropCycleConnectionDto> cropCycleConnectionDtos = pz0EffectiveSeasonalCropCycle.getSeasonalCropCycle().getConnectionDtos();
        if (CollectionUtils.isNotEmpty(cropCycleConnectionDtos)) {
            for (EffectiveCropCycleConnectionDto cropCycleConnectionDto : cropCycleConnectionDtos) {
                String intermediateCropId = cropCycleConnectionDto.getIntermediateCroppingPlanEntryId();
                if (StringUtils.isNotBlank(intermediateCropId)) {
                    CroppingPlanEntryDto persistedCrop = cropIds.get(intermediateCropId);
                    if (persistedCrop != null){

                        intermediateCropId = persistedCrop.getTopiaId();
                        cropCycleConnectionDto.setIntermediateCroppingPlanEntryId(intermediateCropId);

                    }
                }
            }
        }
    }

    protected void propagateTopiaIdToNodes(DomainAndDependencies domainAndDependencies, Map<String, CroppingPlanEntryDto> cropIds, Pz0EffectiveSeasonalCropCycle pz0EffectiveSeasonalCropCycle) {
        Collection<EffectiveCropCycleNodeDto> nodes = pz0EffectiveSeasonalCropCycle.getSeasonalCropCycle().getNodeDtos();
        if (CollectionUtils.isNotEmpty(nodes)) {
            for (EffectiveCropCycleNodeDto node : nodes) {
                    CroppingPlanEntryDto persistedCrop = cropIds.get(node.getCroppingPlanEntryId());
                    if (persistedCrop != null){

                        node.setCroppingPlanEntryId(persistedCrop.getTopiaId());

                        propagateTopiaIdToInterventions(domainAndDependencies, node.getInterventions());

                    }
            }
        }
    }

    protected void propagateTopiaIdToInterventions(DomainAndDependencies domainAndDependencies, Collection<EffectiveInterventionDto> interventions) {
        if (CollectionUtils.isNotEmpty(interventions)) {
            for (EffectiveInterventionDto intervention : interventions) {

                intervention.setDomainId(domainAndDependencies.getEntity().getTopiaId());

            }
        }
    }

    protected void propagateTopiaIdToPerennialCropCycles(EffectiveCropCycleAndDependencies effectiveCropCycleAndDependencies, DomainAndDependencies domainAndDependencies) {
        Map<String, Pz0EffectivePerennialCropCycle> effectivePerennialCropCycleDtosByCsvId = effectiveCropCycleAndDependencies.getEffectivePz0PerennialCropCyclesByCsvId();

        if (effectivePerennialCropCycleDtosByCsvId != null) {
            for (Pz0EffectivePerennialCropCycle pz0PerennialCropCycleDto : effectivePerennialCropCycleDtosByCsvId.values()) {

                EffectivePerennialCropCycleDto perennialCropCycleDto= pz0PerennialCropCycleDto.getPerennialCropCycleDto();
                String csvCropId = perennialCropCycleDto.getCroppingPlanEntryId();
                CroppingPlanEntryDto croppingPlanEntryDto = domainAndDependencies.getCroppingPlanEntryDtosByPZ0CsvId().get(csvCropId);

                perennialCropCycleDto.setCroppingPlanEntryId(croppingPlanEntryDto.getTopiaId());

                propagateTopiaIdToPhases(domainAndDependencies, perennialCropCycleDto);

                propagateTopiaIdToSpecies(domainAndDependencies, perennialCropCycleDto);
            }
        }
    }

    protected void propagateTopiaIdToPhases(DomainAndDependencies domainAndDependencies, EffectivePerennialCropCycleDto perennialCropCycleDto) {
        Collection<EffectiveCropCyclePhaseDto> phaseDtos = perennialCropCycleDto.getPhaseDtos();
        if (CollectionUtils.isNotEmpty(phaseDtos)) {
            for (EffectiveCropCyclePhaseDto phaseDto : phaseDtos) {

                propagateTopiaIdToInterventions(domainAndDependencies, phaseDto.getInterventions());

            }
        }
    }

    protected void propagateTopiaIdToSpecies(DomainAndDependencies domainAndDependencies, EffectivePerennialCropCycleDto perennialCropCycleDto) {
        Collection<EffectiveCropCycleSpeciesDto> speciesDtos = perennialCropCycleDto.getSpeciesDtos();
        if (CollectionUtils.isNotEmpty(speciesDtos)) {
            for (EffectiveCropCycleSpeciesDto speciesDto : speciesDtos) {
                String speciesId = speciesDto.getCroppingPlanSpeciesId();
                CroppingPlanSpeciesDto croppingPlanSpeciesDto = domainAndDependencies.getSpeciesFromCsvId(speciesId);
                Preconditions.checkArgument(croppingPlanSpeciesDto != null, String.format("Espèce %s non retrouvé sur le domain %s", speciesId, domainAndDependencies.getCsvId()));
                speciesDto.setCroppingPlanSpeciesId(croppingPlanSpeciesDto.getTopiaId());
            }
        }
    }
}
