package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: EquipmentImportModel.java 4629 2014-12-10 09:18:38Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/EquipmentImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.EquipmentImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 09/12/14.
 */
public class EquipmentImportModel extends AbstractAgrosystModelExtended<EquipmentImportDto> {

    private static final Log log = LogFactory.getLog(EquipmentImportModel.class);

    public EquipmentImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", "name");
        newMandatoryColumn("description", "description");
        newMandatoryColumn("materieleta", "materielETA",T_F_PARSER);
        newMandatoryColumn("code", "code");
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("domain", "domainId");
        newMandatoryColumn("refmateriel", "refmaterielID");
    }

    @Override
    public EquipmentImportDto newEmptyInstance() {
        return new EquipmentImportDto();
    }

}
