package fr.inra.agrosyst.services.pz0import;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AgrosystCliServiceConfig.java 4945 2015-05-12 15:33:22Z eancelet $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.9/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/AgrosystCliServiceConfig.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.exceptions.AgrosystTechnicalException;
import fr.inra.agrosyst.services.AgrosystServiceConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.PostgreSQL9Dialect;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigOptionDef;

import java.sql.Driver;
import java.util.Properties;

/**
 * Created by davidcosse on 02/12/14.
 */
public class AgrosystCliServiceConfig extends AgrosystServiceConfig {

    private static final Log log = LogFactory.getLog(AgrosystCliServiceConfig.class);

    /**
     * Configuration filename.
     */
    protected static final String AGROSYST_DEFAULT_CONF_FILENAME = "agrosyst-import.properties";

    public AgrosystCliServiceConfig(String configFileName) {
        super(configFileName);
        try {
            ApplicationConfig defaultConfig = new ApplicationConfig(AGROSYST_DEFAULT_CONF_FILENAME);
            defaultConfig.loadDefaultOptions(ServiceConfigOption.values());
            defaultConfig.parse();
            if (StringUtils.isNotBlank(configFileName)) {
                Properties flatOptions = defaultConfig.getFlatOptions(false);

                config = new ApplicationConfig(flatOptions, configFileName);
                config.parse();
            } else {
                if (log.isWarnEnabled()) {
                    log.warn("No specific configuration provided, using the default one");
                }
                config = defaultConfig;
            }
        } catch (ArgumentsParserException ex) {
            throw new AgrosystTechnicalException("Can't read configuration", ex);
        }
    }

    protected String getUserEmail(){
        return config.getOption(ServiceConfigOption.USER_EMAIL.key);
    }

    protected String getUserPassword(){
        return config.getOption(ServiceConfigOption.USER_PASSWORD.key);
    }

    protected String getUserFirstName(){
        return config.getOption(ServiceConfigOption.USER_FIRST_NAME.key);
    }

    protected String getUserLastName(){
        return config.getOption(ServiceConfigOption.USER_LAST_NAME.key);
    }

    protected String getDomainFilePath(){
        return config.getOption(ServiceConfigOption.DOMAIN_FILE_PATH.key);
    }

    protected String getCroppingPanFilePath() {
        return config.getOption(ServiceConfigOption.CROPPING_PLAN_FILE_PATH.key);
    }

    protected String getCroppingPlanSpeciesFilePath() {
        return config.getOption(ServiceConfigOption.CROPPING_PLAN_SPECIES_FILE_PATH.key);
    }

    protected String getEquipmentFilePath() {
        return config.getOption(ServiceConfigOption.EQUIPMENT_FILE_PATH.key);
    }

    protected String getToolCouplingFilePath() {
        return config.getOption(ServiceConfigOption.TOOLS_COUPLING_FILE_PATH.key);
    }

    protected String getEquipmentToToolsCouplingFilePath() {
        return config.getOption(ServiceConfigOption.EQUIPMENT_TO_TOOLS_COUPLING_FILE_PATH.key);
    }

    protected String getMainActionToToolsCouplingFilePath() {
        return config.getOption(ServiceConfigOption.MAIN_ACTION_TO_TOOLS_COUPLING_FILE_PATH.key);
    }

        protected String getGroundFilePath() {
        return config.getOption(ServiceConfigOption.GROUND_FILE_PATH.key);
    }

    protected String getGrowingPlanFilePath() {
        return config.getOption(ServiceConfigOption.GROWING_PLAN_FILE_PATH.key);
    }

    protected String getGrowingSystemFilePath() {
        return config.getOption(ServiceConfigOption.GROWING_SYSTEM_FILE_PATH.key);
    }

    protected String getPlotFilePath() {
        return config.getOption(ServiceConfigOption.PLOT_FILE_PATH.key);
    }

    protected String getZoneFilePath() {
        return config.getOption(ServiceConfigOption.ZONE_FILE_PATH.key);
    }

    protected String getPracticedSystemFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_SYSTEM_FILE_PATH.key);
    }

    protected String getPracticedPlotFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_PLOT_FILE_PATH.key);
    }

    protected String getPracticedCropCycleFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_CROP_CYCLE_FILE_PATH.key);
    }

    protected String getPracticedSeasonalCropCycleFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_SEASONAL_CROP_CYCLE_FILE_PATH.key);
    }

    protected String getPracticedCropCycleNodeFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_CROP_CYCLE_NODE_FILE_PATH.key);
    }

    protected String getPracticedCropCycleConnectionFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_CROP_CYCLE_CONNECTION_FILE_PATH.key);
    }

    protected String getPracticedPerennialCropCycleFilePathFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_PERENNIAL_CROP_CYCLE_FILE_PATH.key);
    }

    protected String getPracticedCropCyclePhaseFilePathFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_CROP_CYCLE_PHASE_FILE_PATH.key);
    }

    protected String getPracticedCropCycleSpeciesFilePathFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_CROP_CYCLE_SPECIES_FILE_PATH.key);
    }

    protected String getPracticedInterventionFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_INTERVENTION_FILE_PATH.key);
    }

    protected String getPracticeInterventionToolsCouplingFilePath() {
        return config.getOption(ServiceConfigOption.PRACTICED_INTERVENTION_TOOLS_COUPLING_FILE_PATH.key);
    }


    protected String getEffectiveCropCycleSpeciesFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_CROP_CYCLE_SPECIES_FILE_PATH.key);
    }

    protected String getEffectivePerennialCropCycleFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_PERENNIAL_CROP_CYCLE_FILE_PATH.key);
    }

    protected String getEffectivePhaseFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_PHASE_FILE_PATH.key);
    }

    protected String getEffectiveSeasonalCropCycleFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_SEASONAL_CROP_CYCLE_FILE_PATH.key);
    }
    protected String getEffectiveCropCycleNodeFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_CROP_CYCLE_NODE_FILE_PATH.key);
    }
    protected String getEffectiveCropCycleConnectionFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_CROP_CYCLE_CONNECTION_FILE_PATH.key);
    }

    protected String getEffectiveInterventionFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_INTERVENTION_FILE_PATH.key);
    }
    protected String getEffectiveSpeciesStadeFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_SPECIES_STADE_FILE_PATH.key);
    }
    protected String getEffectiveToolsCouplingFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_TOOLS_COUPLING_FILE_PATH.key);
    }
    protected String getEffectiveInvolvedRuleFilePath() {
        return config.getOption(ServiceConfigOption.EFFECTIVE_INVOLVED_RULE_FILE_PATH.key);
    }

    protected String getAbstractActionFilePath() {
        return config.getOption(ServiceConfigOption.ABSTRACT_ACTION_FILE_PATH.key);
    }

    protected String getSeedingActionSpeciesFilePath() {
        return config.getOption(ServiceConfigOption.SEEDING_ACTION_SPECIES_FILE_PATH.key);
    }

    protected String getHarverstingYealdFilePath() {
        return config.getOption(ServiceConfigOption.HARVESTING_YEALD_FILE_PATH.key);
    }

    protected String getAbstractInputFilePath() {
        return config.getOption(ServiceConfigOption.ABSTRACT_INPUT_FILE_PATH.key);
    }

    protected String getRefFertiMinUnifaFilePath() {
        return config.getOption(ServiceConfigOption.REF_FERTI_MIN_UNIFA_FILE_PATH.key);
    }

    public String getUsersRolesFilePath() {
        return config.getOption(ServiceConfigOption.USERS_ROLES_FILE_PATH.key);
    }

    public String getGrowingSystemNetworkFilePath() {
        return config.getOption(ServiceConfigOption.GROWING_SYSTEM_NETWORKS.key);
    }

    static enum ServiceConfigOption implements ConfigOptionDef {
        // default values to an other database used by INRA
        DATABASE_HBM2DLL_AUTO(Environment.HBM2DDL_AUTO, "validate"),
        DATABASE_DIALECT(Environment.DIALECT, PostgreSQL9Dialect.class.getName()),
        DATABASE_DRIVER(Environment.DRIVER, Driver.class.getName()),
        DATABASE_URL(Environment.URL, "jdbc:postgresql:agrosyst-cli"),
        DATABASE_USER(Environment.USER, "agrosyst"),
        DATABASE_PASS(Environment.PASS, "agrosyst"),

        DATABASE_C3P0_MIN_SIZE(Environment.C3P0_MIN_SIZE, "5"),
        DATABASE_C3P0_MAX_SIZE(Environment.C3P0_MAX_SIZE, "20"),
        DATABASE_C3P0_TIMEOUT(Environment.C3P0_TIMEOUT, "300"),
        DATABASE_C3P0_MAX_STATEMENTS(Environment.C3P0_MAX_STATEMENTS, "50"),

        USER_EMAIL("userEmail", "admin@test.fr"),
        USER_PASSWORD("userPassword", "azerty"),
        USER_FIRST_NAME("userFirstName", "Admin"),
        USER_LAST_NAME("userLastName", "Test"),
        DOMAIN_FILE_PATH("domainFilePath", null),
        GROWING_PLAN_FILE_PATH("growingPlanFilePath", null),
        GROWING_SYSTEM_FILE_PATH("growingSystemFilePath", null),
        GROWING_SYSTEM_NETWORKS("growingSystemNetworksFilePath", null),

        CROPPING_PLAN_FILE_PATH("croppingPlanFilePath", null),
        CROPPING_PLAN_SPECIES_FILE_PATH("croppingPlanSpeciesFilePath", null),
        EQUIPMENT_FILE_PATH("equipmentFilePath", null),
        TOOLS_COUPLING_FILE_PATH("toolsCouplingFilePath", null),
        EQUIPMENT_TO_TOOLS_COUPLING_FILE_PATH("equipmentToToolsCouplingFilePath", null),
        MAIN_ACTION_TO_TOOLS_COUPLING_FILE_PATH("mainActionToToolsCouplingFilePath", null),
        GROUND_FILE_PATH("groundFilePath", null),

        PLOT_FILE_PATH("plotFilePath", null),
        PRACTICED_SYSTEM_FILE_PATH("practicedSystemFilePath", null),
        PRACTICED_PLOT_FILE_PATH("practicedPlotFilePath", null),
        PRACTICED_CROP_CYCLE_FILE_PATH("practicedCropCycleFilePath", null),

        PRACTICED_SEASONAL_CROP_CYCLE_FILE_PATH("practicedSeasonalCropCycleFilePath", null),
        PRACTICED_CROP_CYCLE_NODE_FILE_PATH("practicedCropCycleNodeFilePath", null),
        PRACTICED_CROP_CYCLE_CONNECTION_FILE_PATH("practicedCropCycleConnectionFilePath", null),

        PRACTICED_PERENNIAL_CROP_CYCLE_FILE_PATH("practicedPerennialCropCycleFilePath", null),
        PRACTICED_CROP_CYCLE_PHASE_FILE_PATH("practicedCropCyclePhaseFilePath", null),
        PRACTICED_CROP_CYCLE_SPECIES_FILE_PATH("practicedCropCycleSpeciesFilePath", null),

        PRACTICED_INTERVENTION_FILE_PATH("practicedInterventionFilePath", null),
        PRACTICED_INTERVENTION_TOOLS_COUPLING_FILE_PATH("practiceInterventionToolsCouplingFilePath", null),

        EFFECTIVE_CROP_CYCLE_SPECIES_FILE_PATH("effectiveCropCycleSpeciesFilePath", null),
        EFFECTIVE_PERENNIAL_CROP_CYCLE_FILE_PATH("effectivePerennialCropCycleFilePath", null),
        EFFECTIVE_PHASE_FILE_PATH("effectivePhaseFilePath", null),

        EFFECTIVE_SEASONAL_CROP_CYCLE_FILE_PATH("effectiveSeasonalCropCycleFilePath", null),
        EFFECTIVE_CROP_CYCLE_NODE_FILE_PATH("effectiveCropCycleNodeFilePath", null),
        EFFECTIVE_CROP_CYCLE_CONNECTION_FILE_PATH("effectiveCropCycleConnectionFilePath", null),

        EFFECTIVE_INTERVENTION_FILE_PATH("effectiveInterventionFilePath", null),
        EFFECTIVE_SPECIES_STADE_FILE_PATH("effectiveSpeciesStadeFilePath", null),
        EFFECTIVE_TOOLS_COUPLING_FILE_PATH("effectiveToolsCouplingFilePath", null),
        EFFECTIVE_INVOLVED_RULE_FILE_PATH("effectiveInvolvedRuleFilePath", null),

        ABSTRACT_ACTION_FILE_PATH("abstractActionFilePath", null),
        SEEDING_ACTION_SPECIES_FILE_PATH("seedingActionSpeciesFilePath", null),
        HARVESTING_YEALD_FILE_PATH("harverstingYealdFilePath", null),
        ABSTRACT_INPUT_FILE_PATH("abstractInputFilePath", null),
        REF_FERTI_MIN_UNIFA_FILE_PATH("refFertiMinUnifaFilePath", null),
        ZONE_FILE_PATH("zoneFilePath", null),

        USERS_ROLES_FILE_PATH("usersRolesFilePath", null);

        private String key;
        private String defaultValue;

        private ServiceConfigOption(String key, String defaultValue) {
            this.key = key;
            this.defaultValue = defaultValue;
        }

        @Override
        public String getKey() {
            return key;
        }

        @Override
        public String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public Class<?> getType() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public boolean isTransient() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return false;
        }

        @Override
        public void setDefaultValue(String defaultValue) {

        }

        @Override
        public void setTransient(boolean isTransient) {

        }

        @Override
        public void setFinal(boolean isFinal) {

        }
    }
}
