package fr.inra.agrosyst.services.pz0import.practicedPlot;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedPlotImportModel.java 4756 2015-02-04 15:23:40Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedPlot/PracticedPlotImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 29/01/15.
 */
public class PracticedPlotImportModel extends AbstractAgrosystModelExtended<PracticedPlotImportDto> {


    protected PracticedPlotImportModel() {
        super(';');
        newMandatoryColumn("topiaid", PracticedPlotImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", PracticedPlotImportDto.PROPERTY_NAME);
        newMandatoryColumn("area", PracticedPlotImportDto.PROPERTY_AREA, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("pacilotnumber", PracticedPlotImportDto.PROPERTY_PAC_ILOT_NUMBER, INT_PARSER);
        newMandatoryColumn("latitude", PracticedPlotImportDto.PROPERTY_LATITUDE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("longitude", PracticedPlotImportDto.PROPERTY_LONGITUDE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("comment", PracticedPlotImportDto.PROPERTY_COMMENT);
        newMandatoryColumn("activityendcomment", PracticedPlotImportDto.PROPERTY_ACTIVITY_END_COMMENT);
        newMandatoryColumn("active", PracticedPlotImportDto.PROPERTY_ACTIVE, T_F_PARSER);
        newMandatoryColumn("outofzoning", PracticedPlotImportDto.PROPERTY_OUT_OF_ZONING, T_F_PARSER);
        newMandatoryColumn("zoningcomment", PracticedPlotImportDto.PROPERTY_ZONING_COMMENT);
        newMandatoryColumn("irrigationsystem", PracticedPlotImportDto.PROPERTY_IRRIGATION_SYSTEM, T_F_PARSER);
        newMandatoryColumn("fertigationsystem", PracticedPlotImportDto.PROPERTY_FERTIGATION_SYSTEM, T_F_PARSER);
        newMandatoryColumn("waterorigin", PracticedPlotImportDto.PROPERTY_WATER_ORIGIN);
        newMandatoryColumn("drainage", PracticedPlotImportDto.PROPERTY_DRAINAGE, T_F_PARSER);
        newMandatoryColumn("drainageyear", PracticedPlotImportDto.PROPERTY_DRAINAGE_YEAR, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("frostprotection", PracticedPlotImportDto.PROPERTY_FROST_PROTECTION, T_F_PARSER);
        newMandatoryColumn("hailprotection", PracticedPlotImportDto.PROPERTY_HAIL_PROTECTION, T_F_PARSER);
        newMandatoryColumn("rainproofprotection", PracticedPlotImportDto.PROPERTY_RAINPROOF_PROTECTION,T_F_PARSER);
        newMandatoryColumn("pestprotection", PracticedPlotImportDto.PROPERTY_PEST_PROTECTION, T_F_PARSER);
        newMandatoryColumn("otherequipment", PracticedPlotImportDto.PROPERTY_OTHER_EQUIPMENT);
        newMandatoryColumn("equipmentcomment", PracticedPlotImportDto.PROPERTY_EQUIPMENT_COMMENT);
        newMandatoryColumn("solstoniness", PracticedPlotImportDto.PROPERTY_SOL_STONINESS, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solmaxdepth", PracticedPlotImportDto.PROPERTY_SOL_MAX_DEPTH, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solorganicmaterialpercent", PracticedPlotImportDto.PROPERTY_SOL_ORGANIC_MATERIAL_PERCENT, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solhydromorphisms", PracticedPlotImportDto.PROPERTY_SOL_HYDROMORPHISMS, T_F_PARSER);
        newMandatoryColumn("soltotallimestone", PracticedPlotImportDto.PROPERTY_SOL_TOTAL_LIMESTONE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("sollimestone", PracticedPlotImportDto.PROPERTY_SOL_LIMESTONE, T_F_PARSER);
        newMandatoryColumn("solactivelimestone", PracticedPlotImportDto.PROPERTY_SOL_ACTIVE_LIMESTONE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("solbattance", PracticedPlotImportDto.PROPERTY_SOL_BATTANCE, T_F_PARSER);
        newMandatoryColumn("solcomment", PracticedPlotImportDto.PROPERTY_SOL_COMMENT);
        newMandatoryColumn("adjacentcomment", PracticedPlotImportDto.PROPERTY_ADJACENT_COMMENT);
        newMandatoryColumn("waterflowdistance", "waterFlowDistanceImportedValue");
        newMandatoryColumn("irrigationsystemtype", "irrigationSystemTypeImportedValue");
        newMandatoryColumn("pompenginetype", "pompEngineTypeImportedValue");
        newMandatoryColumn("hosespositionning", "hosesPositionningImportedValue");
        newMandatoryColumn("frostprotectiontype", "frostProtectionTypeImportedValue");
        newMandatoryColumn("surfacetexture", PracticedPlotImportDto.PROPERTY_SURFACE_TEXTURE_ID);
        newMandatoryColumn("soldepth", PracticedPlotImportDto.PROPERTY_SOL_DEPTH_ID);
        newMandatoryColumn("solwaterph", "solWaterPhImportedValue");
        newMandatoryColumn("maxslope", "maxSlopeImportedValue");
        newMandatoryColumn("subsoiltexture", PracticedPlotImportDto.PROPERTY_SUB_SOIL_TEXTURE_ID);
        newMandatoryColumn("bufferstrip", "bufferStripImportedValue");
        newMandatoryColumn("location", PracticedPlotImportDto.PROPERTY_LOCATION_ID);
        newMandatoryColumn("practicedsystem", PracticedPlotImportDto.PROPERTY_PRACTICED_SYSTEM_ID);
    }

    @Override
    public PracticedPlotImportDto newEmptyInstance() {
        return new PracticedPlotImportDto();
    }


}
