package fr.inra.agrosyst.services.pz0import.input;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 24/02/15.
 */
public class InputModel extends AbstractAgrosystModelExtended<InputImportDto> {

    protected InputModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newMandatoryColumn("topiadiscriminator", "topiaDiscriminator");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("qtmin", "qtMin", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("qtavg", "qtAvg", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("qtmed", "qtMed", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("qtmax", "qtMax", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("productname", "productName");
        newMandatoryColumn("inputtype", "inputTypeName");
        newMandatoryColumn("mineralproduct", "mineralProductId");
        newMandatoryColumn("mineralproductunit", "mineralProductUnitName");
        newMandatoryColumn("mineralfertilizersspreadingaction", "mineralFertilizersSpreadingActionId");
        newMandatoryColumn("otherproductqtunit", "otherProductQtUnit");
        newMandatoryColumn("otheraction", "otherActionId");
        newMandatoryColumn("producttype", "productType");
        newMandatoryColumn("phytoproduct", "phytoProductId");
        newMandatoryColumn("phytoproductunit", "phytoProductUnitName");
        newMandatoryColumn("pesticidesspreadingaction", "pesticidesSpreadingActionId");
        newMandatoryColumn("seedingaction", "seedingActionId");
        newMandatoryColumn("biologicalcontrolaction", "biologicalControlActionId");
        newMandatoryColumn("n", "n", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("p2o5", "p2o5", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("k2o", "k2o", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("organicproduct", "organicProductId");
        newMandatoryColumn("organicfertilizersspreadingaction", "organicFertilizersSpreadingActionId");
        newMandatoryColumn("organicproductunit", "organicProductUnitName");
    }

    @Override
    public InputImportDto newEmptyInstance() {
        return new InputImportDto();
    }
}
