package fr.inra.agrosyst.services.pz0import.growingsystem;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GrowingSystemImportModel.java 4783 2015-02-11 16:36:22Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/growingsystem/GrowingSystemImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import org.nuiton.csv.ValueParser;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 *
 * @author eanceletr
 */
public class GrowingSystemImportModel extends AbstractAgrosystModelExtended<GrowingSystemImportDto> {

    private static final Log log = LogFactory.getLog(GrowingSystemImportModel.class);

    public GrowingSystemImportModel() {
        super(';');
        newMandatoryColumn("topiaid", GrowingSystemImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", GrowingSystem.PROPERTY_CODE);
        newMandatoryColumn("growingplan", GrowingSystemImportDto.PROPERTY_GROWINGPLAN_ID);
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", GrowingSystem.PROPERTY_NAME);
        newMandatoryColumn("dephynumber", GrowingSystem.PROPERTY_DEPHY_NUMBER);
        newMandatoryColumn("description", GrowingSystem.PROPERTY_DESCRIPTION);
        newMandatoryColumn("affectedarearate", GrowingSystem.PROPERTY_AFFECTED_AREA_RATE,DOUBLE_WITH_NULL_PARSER);
        newMandatoryColumn("affectedworkforcerate", GrowingSystem.PROPERTY_AFFECTED_WORK_FORCE_RATE,INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("domainstoolsusagerate", GrowingSystem.PROPERTY_DOMAINS_TOOLS_USAGE_RATE,INTEGER_WITH_NULL_PARSER);
        newMandatoryColumn("active", GrowingSystem.PROPERTY_ACTIVE, T_F_PARSER);        
        newIgnoredColumn("startingdate");
        newIgnoredColumn("endingdate");
        newMandatoryColumn("endactivitycomment", GrowingSystem.PROPERTY_END_ACTIVITY_COMMENT);
        newMandatoryColumn("conductmodecomment", GrowingSystem.PROPERTY_CONDUCT_MODE_COMMENT);
        newMandatoryColumn("plotoutputreason", GrowingSystem.PROPERTY_PLOT_OUTPUT_REASON);
        newMandatoryColumn("validated", GrowingSystem.PROPERTY_VALIDATED, T_F_PARSER);
        newMandatoryColumn("validationdate", GrowingSystem.PROPERTY_VALIDATION_DATE, DATE_PARSER);
        newMandatoryColumn("updatedate", GrowingSystem.PROPERTY_UPDATE_DATE, ENDING_DATE_PARSER);
        newMandatoryColumn("cyclemanagementcomment", GrowingSystem.PROPERTY_CYCLE_MANAGEMENT_COMMENT);
        newMandatoryColumn("culturemanagementcomment", GrowingSystem.PROPERTY_CULTURE_MANAGEMENT_COMMENT);
        newMandatoryColumn("groundworkcomment", GrowingSystem.PROPERTY_GROUND_WORK_COMMENT);
        newMandatoryColumn("parcelsmanagementcomment", GrowingSystem.PROPERTY_PARCELS_MANAGEMENT_COMMENT);
        newMandatoryColumn("sector", "sectorImporterValue");
        newMandatoryColumn("typeagriculture", GrowingSystemImportDto.PROPERTY_TYPE_AGRICULTURE_ID);
        newMandatoryColumn("categorystrategy", "categoryStrategyImporterValue");
    }

    @Override
    public GrowingSystemImportDto newEmptyInstance() {
        return new GrowingSystemImportDto();
    }

    protected static final ValueParser<Date> ENDING_DATE_PARSER = new ValueParser<Date>() {
        @Override
        public Date parse(String value) throws ParseException {
            Date result;
            if (!Strings.isNullOrEmpty(value)) {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                result = format.parse(value);
            } else {
                result = new Date();
            }
            return result;
        }
    };
}
