package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: ToolsCouplingImportModel.java 4748 2015-02-03 09:28:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/ToolsCouplingImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.ToolCouplingImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 09/12/14.
 */
public class ToolsCouplingImportModel extends AbstractAgrosystModelExtended<ToolCouplingImportDto> {

    private static final Log log = LogFactory.getLog(ToolsCouplingImportModel.class);

    public ToolsCouplingImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("toolscouplingname", ToolsCoupling.PROPERTY_TOOLS_COUPLING_NAME);
        newMandatoryColumn("workforce", ToolsCoupling.PROPERTY_WORKFORCE, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("comment", ToolsCoupling.PROPERTY_COMMENT);
        newMandatoryColumn("code", ToolsCoupling.PROPERTY_CODE);
        newMandatoryColumn("validated", ToolsCoupling.PROPERTY_VALIDATED, T_F_PARSER);
        newMandatoryColumn("tractor", "tractorId");
        newMandatoryColumn("domain", "domainId");
        newMandatoryColumn("workrate", ToolsCoupling.PROPERTY_WORK_RATE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("workrateunit", "workrateUnitImporterValue");
        newMandatoryColumn("transitvolume", ToolsCoupling.PROPERTY_TRANSIT_VOLUME, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("manualintervention", ToolsCoupling.PROPERTY_MANUAL_INTERVENTION, T_F_PARSER);
    }

    @Override
    public ToolCouplingImportDto newEmptyInstance() {
        return new ToolCouplingImportDto();
    }

}
