package fr.inra.agrosyst.services.pz0import.domain.model;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: CroppingPlanSpeciesImportModel.java 4607 2014-12-05 21:03:36Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/model/CroppingPlanSpeciesImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;
import fr.inra.agrosyst.services.pz0import.domain.dto.CroppingPlanSpeciesImportDto;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * Created by davidcosse on 05/12/14.
 */
public class CroppingPlanSpeciesImportModel extends AbstractAgrosystModelExtended<CroppingPlanSpeciesImportDto> {

    private static final Log log = LogFactory.getLog(CroppingPlanSpeciesImportModel.class);

    public CroppingPlanSpeciesImportModel() {
        super(';');

        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("code", "code");
        newMandatoryColumn("validated", "validated", T_F_PARSER);
        newMandatoryColumn("variety", "varietyId");
        newMandatoryColumn("croppingplanentry", "croppingPlanEntryId");
        newMandatoryColumn("species", "speciesId");
        newMandatoryColumn("croppingplanentry_idx", "croppingplanentry_idx", INTEGER_WITH_NULL_AND_9999_PARSER);
    }

    @Override
    public CroppingPlanSpeciesImportDto newEmptyInstance() {
        return new CroppingPlanSpeciesImportDto();
    }

}
