package fr.inra.agrosyst.services.pz0import.action.seedingActionSpecies;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: SeedingActionSpeciesImporter.java 4802 2015-02-17 10:48:07Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/seedingActionSpecies/SeedingActionSpeciesImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.api.entities.action.HarvestingAction;
import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.api.entities.action.HarvestingYealdImpl;
import fr.inra.agrosyst.api.entities.action.SeedPlantUnit;
import fr.inra.agrosyst.api.entities.action.SeedingAction;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.api.entities.action.SeedingActionSpeciesImpl;
import fr.inra.agrosyst.api.entities.action.YealdCategory;
import fr.inra.agrosyst.api.entities.referential.RefInterventionAgrosystTravailEDITopiaDao;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 12/02/15.
 */
public class SeedingActionSpeciesImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(SeedingActionSpeciesImporter.class);

    protected RefInterventionAgrosystTravailEDITopiaDao refInterventionAgrosystTravailEDIDao;

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(SeedingActionSpecies.class);
        log.debug(String.format("importfromstream"));

        SeedingActionSpeciesModel model = new SeedingActionSpeciesModel();
        // récupère le DTO
        Import<SeedingActionSpeciesImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (SeedingActionSpeciesImportDto dto : importer) {
            boolean error = false;

            // valid required fields
            error = validSeedingSpeciesAction(importResults, line, dto, error);

            error = validSeedPlanUnit(importResults, line, dto, error);

            //todo treatment and biologicalSeedInoculation

            if (!error) {
                setQuantity(dto);
                SeedingActionSpecies seedingActionSpecies = new SeedingActionSpeciesImpl();
                Binder<SeedingActionSpeciesImportDto, SeedingActionSpecies> binder = BinderFactory.newBinder(SeedingActionSpeciesImportDto.class, SeedingActionSpecies.class);
                binder.copy(dto, seedingActionSpecies);
                SeedingAction seedingAction = (SeedingAction)pz0IdToObject.get(AbstractAction.class, dto.getSeedingActionId());
                seedingAction.addSeedingSpecies(seedingActionSpecies);

                importResults.addInfoLine(line, "AJOUT D'UNE ESPÈCE POUR L'ACTION DE TYPE SEMIS VALIDÉ");
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "AJOUT D'UNE ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ");
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSeedingSpeciesAction(ImportResults importResults, long line, SeedingActionSpeciesImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getSeedingActionId())) {
            SeedingAction seedingAction = (SeedingAction)pz0IdToObject.get(AbstractAction.class, from.getSeedingActionId());
            if (seedingAction == null) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, L'action de semis avec l'identifiant %s n'a pas été retrouvé.", from.getSeedingActionId()));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, La colonne 'seedingaction' doit être renseignée.");
        }

        return error;
    }

    protected boolean validSeedPlanUnit(ImportResults importResults, long line, SeedingActionSpeciesImportDto from, boolean error) {

        if (StringUtils.isNotBlank(from.getSeedPlantUnitName())) {
            try{
                SeedPlantUnit seedPlantUnit = SeedPlantUnit.valueOf(from.getSeedPlantUnitName());
                from.setSeedPlantUnit(seedPlantUnit);
            } catch (IllegalArgumentException e) {
                error = true;
                importResults.addErrorLine(line, String.format("AJOUT DE L'ESPÈCE POUR L'ACTION DE TYPE SEMIS IGNORÉ!, unité de simis incorrect %s.", from.getSeedPlantUnitName()));
            }
        }

        return error;
    }

    protected void setQuantity(SeedingActionSpeciesImportDto from) {

        if (from.getQuantityWithNull() != null) {
            from.setQuantity(from.getQuantityWithNull());
        } else {
            from.setQuantity(0);
        }
    }

}
