package fr.inra.agrosyst.services.pz0import;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AbstractAgrosystModelExtended.java 4748 2015-02-03 09:28:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.7/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/AbstractAgrosystModelExtended.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.base.Strings;

import fr.inra.agrosyst.services.referential.csv.AbstractAgrosystModel;

import java.text.ParseException;

import org.nuiton.csv.ValueParser;

/**
 *
 * @author schellen
 */
public abstract class AbstractAgrosystModelExtended<E> extends AbstractAgrosystModel<E> {

    protected AbstractAgrosystModelExtended(char separator) {
        super(separator);
    }

    /**
     * True/False boolean parser.
     */
    protected static final ValueParser<Boolean> T_F_PARSER = new ValueParser<Boolean>() {
        @Override
        public Boolean parse(String value) throws ParseException {
            Boolean result;
            if ("T".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value)) {
                result = Boolean.TRUE;
            } else {
                result = Boolean.FALSE;
            }
            return result;
        }
    };

    protected static final ValueParser<Integer> INTEGER_WITH_NULL_AND_9999_PARSER = new ValueParser<Integer>() {
        @Override
        public Integer parse(String value) throws ParseException {
            Integer result = null;
            if (!Strings.isNullOrEmpty(value)) {
                result = Integer.valueOf(value);
                result = new Integer(9999).equals(result) ? null : result;
            }
            return result;
        }
    };

    protected static final ValueParser<Double> DOUBLE_WITH_NULL_AND_9999_PARSER =  new ValueParser<Double>() {
        @Override
        public Double parse(String value) throws ParseException {
            Double result = null;
            if (!value.isEmpty()) {
                // " " est un espace insécable, pas un " "
                result = Double.valueOf(value.replace(',','.').replace(" ", ""));
                result = new Double(9999).equals(result) ? null : result;
            }
            return result;
        }
    };
}
