package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedInterventionToolsCoupling;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedToolsCouplingImporter.java 4795 2015-02-17 06:32:47Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/1.4.6/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedInterventionToolsCoupling/PracticedToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImportDto;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 06/02/15.
 */
public class PracticedToolsCouplingImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedToolsCouplingImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedToolsCouplingImportDto.class);
        log.debug(String.format("importfromstream"));

        PracticedToolsCouplingImportModel model = new PracticedToolsCouplingImportModel();
        // récupère le DTO
        Import<PracticedToolsCouplingImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedToolsCouplingImportDto dto : importer) {
            boolean error = false;


            // valid required fields
            error = validToolsCouplingInterventionAssociation(importResults, line, dto, error);

            error = validToolsCouplingCode(importResults, line, dto, error);

            if (!error) {
                dto.getInterventionDto().addToolsCouplingCode(dto.getToolsCouplingCode());
                importResults.addInfoLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION VALIDÉE");
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE");
            }
            line++;
        }
        return importResults;
    }

    protected boolean validToolsCouplingInterventionAssociation(ImportResults importResults, long line, PracticedToolsCouplingImportDto from, boolean error) {
        String interventionId = from.getInterventionId();
        if(StringUtils.isNotBlank(interventionId)){
            PracticedInterventionDto interventionDto = (PracticedInterventionDto)pz0IdToObject.get(PracticedInterventionDto.class, interventionId);
            if(interventionDto != null) {
                from.setInterventionDto(interventionDto);
            } else {
                importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, l'intervention avec comme id: %s n'a pu être retrouvée.", interventionId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la colonne 'owner' doit-être renseignés.");
            error = true;
        }
        return error;
    }

    protected boolean validToolsCouplingCode(ImportResults importResults, long line, PracticedToolsCouplingImportDto from, boolean error) {
        if(!error) {
            String toolsCouplingCode = from.getToolsCouplingCode();
            if (StringUtils.isNotBlank(toolsCouplingCode)){
                String connectionId = (String) pz0IdToObject.get(PracticedInterventionDto.class, PracticedCropCycleConnectionDto.class, from.getInterventionId());
                if (connectionId != null) {
                    PracticedCropCycleConnectionDto connectionDto = (PracticedCropCycleConnectionDto)pz0IdToObject.get(PracticedCropCycleConnectionDto.class, connectionId);
                    String newNodeId = connectionDto.getTargetId();
                    String nodeId = StringUtils.remove(newNodeId, "new-node-");
                    PracticedCropCycleNodeImportDto nodeImportDto = (PracticedCropCycleNodeImportDto)pz0IdToObject.get(PracticedCropCycleNodeImportDto.class, nodeId);
                    DomainAndDependencies domainAndDependencies = PracticedCropCycleNodeImporter.getDomainAndDependenciesFromNode(nodeImportDto);
                    Map<String, ToolsCoupling> toolsCouplingMap = domainAndDependencies.getToolsCouplingsByCode();
                    String agrosystToolsCouplingCode = pz0CodeToAgrosystCode.get(ToolsCoupling.class, toolsCouplingCode);
                    ToolsCoupling toolsCoupling = toolsCouplingMap.get(agrosystToolsCouplingCode);
                    if(toolsCoupling == null) {
                        importResults.addErrorLine(line, String.format("AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la combinaison d'outil avec comme identifiant %s n'a pu être retrouvée.", toolsCouplingCode));
                        error = true;
                    }
                } else {
                    String phaseId = (String) pz0IdToObject.put(PracticedInterventionDto.class, PracticedCropCyclePhaseDto.class, from.getInterventionId());
                    // TODO DCossé 06/02/15 
                }
            } else {
                importResults.addErrorLine(line, "AJOUT DE LA COMBINAISON D'OUTIL À L'INTERVENTION IGNORÉE!, la colonne 'toolscouplingcodes' doit-être renseignés.");
                error = true;
            }
        }

        return error;
    }

}
