package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleImporter.java 4789 2015-02-12 16:58:15Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/1.4.6/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycle/PracticedCropCycleImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 03/02/15.
 */
public class PracticedCropCycleImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycleImporter.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycle.class);
        log.debug(String.format("importfromstream"));

        PracticedCropCycleImportModel model = new PracticedCropCycleImportModel();
        // récupère le DTO
        Import<PracticedCropCycleImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleImportDto dto : importer) {
            boolean error = false;

            // valid required fields
            error = validPracticedSystemAffiliation(importResults, line, dto, entitiesByCsvId, error);

            if (!error) {
                importResults.addInfoLine(line, "CYCLE DE CULTURE DU SYNTHÉTISÉ VALIDÉ, csvid: " + dto.getId());
                pz0IdToObject.put(PracticedCropCycle.class,  dto.getId(), dto);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validPracticedSystemAffiliation(ImportResults importResults, long line, PracticedCropCycleImportDto dto, Map<String, EntityAndDependencies> entityAndDependenciesMap, boolean error) {
        String target = dto.getPracticedSystemId();
        if (StringUtils.isNotBlank(target)) {
            EntityAndDependencies practicedSystemAndDependencies = entityAndDependenciesMap.get(target);
            if (practicedSystemAndDependencies == null) {
                importResults.addErrorLine(line, String.format("CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, aucun système pratiqué n'est retrouvée avec l'identifiant suivant: %s", target));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CYCLE DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'practicedsystem' n'est pas renseignée pour le SDC %s!");
            error = true;
        }
        return error;
    }

}
