package fr.inra.agrosyst.services.pz0import.action.seedingActionSpecies;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: SeedingActionSpeciesModel.java 4796 2015-02-17 06:42:30Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/1.4.6/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/seedingActionSpecies/SeedingActionSpeciesModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.SeedingActionSpecies;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 12/02/15.
 */
public class SeedingActionSpeciesModel extends AbstractAgrosystModelExtended<SeedingActionSpeciesImportDto> {

    protected SeedingActionSpeciesModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("quantity", "quantityWithNull", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("deepness", SeedingActionSpecies.PROPERTY_DEEPNESS, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("speciescode", SeedingActionSpecies.PROPERTY_SPECIES_CODE);
        newMandatoryColumn("seedplantunit", "seedPlantUnitName");
        newMandatoryColumn("seedingaction", "seedingActionId");
    }

    @Override
    public SeedingActionSpeciesImportDto newEmptyInstance() {
        return new SeedingActionSpeciesImportDto();
    }
}
