package fr.inra.agrosyst.services.pz0import.action.harvestingYeald;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: HarvestingYealdModel.java 4796 2015-02-17 06:42:30Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/1.4.6/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/harvestingYeald/HarvestingYealdModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.action.HarvestingYeald;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 12/02/15.
 */
public class HarvestingYealdModel extends AbstractAgrosystModelExtended<HarvestingYealdImportDto> {

    protected HarvestingYealdModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("yealdmin", HarvestingYeald.PROPERTY_YEALD_MIN, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdmax", HarvestingYeald.PROPERTY_YEALD_MAX, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdaverage", "yealdAverageWithNull", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdmedian", HarvestingYeald.PROPERTY_YEALD_MEDIAN, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("yealdcategory", "yealdCategoryName");
        newMandatoryColumn("yealdunit", "yealdUnitName");
        newMandatoryColumn("harvestingaction", "harvestingActionId");
    }

    @Override
    public HarvestingYealdImportDto newEmptyInstance() {
        return new HarvestingYealdImportDto();
    }
}
