package fr.inra.agrosyst.services.pz0import.action;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: ActionModel.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/1.4.6/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/action/ActionModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.action.AbstractAction;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 09/02/15.
 */
public class ActionModel extends AbstractAgrosystModelExtended<ActionImportDto> {

    protected ActionModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newMandatoryColumn("topiadiscriminator", "topiaDiscriminator");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("comment", "comment");
        newMandatoryColumn("toolscouplingcode", "toolsCouplingCode");
        newMandatoryColumn("practicedintervention", "practicedInterventionId");
        newMandatoryColumn("effectiveintervention", "effectiveInterventionId");
        newMandatoryColumn("mainaction", "mainActionId");
        newMandatoryColumn("moisturepercent", "moisturePercent", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("exportedwaste", "exportedWaste", T_F_PARSER);
        newMandatoryColumn("yealdtarget", "yealdTarget", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("seedtype", "seedTypeName");
        newMandatoryColumn("yealdunit", "yealdUnitName");
        newMandatoryColumn("tillagedepth", "tillageDepth", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("othersettingtool", "otherSettingTool");
        newMandatoryColumn("boiledquantity", "boiledQuantity", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("boiledquantitypertrip", "boiledQuantityPerTrip", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("tripfrequency", "tripFrequency", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("antidriftnozzle", "antiDriftNozzle", T_F_PARSER);
        newMandatoryColumn("quantityunitedi", "quantityUnitEdiName");
        newMandatoryColumn("loadcapacity", "loadCapacity", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("capacityunit", "capacityUnitName");
        newMandatoryColumn("burial", "burial", T_F_PARSER);
        newMandatoryColumn("localizedspreading", "localizedSpreading", T_F_PARSER);
        newMandatoryColumn("landfilledwaste", "landFilledWaste", T_F_PARSER);
        newMandatoryColumn("waterquantitymin", "waterQuantityMin", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("waterquantitymax", "waterQuantityMax", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("waterquantityaverage", "waterQuantityAverage", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("waterquantitymedian", "waterQuantityMedian", DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("azotequantity", "azoteQuantity", INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("proportionoftreatedsurface", "proportionOfTreatedSurface", DOUBLE_WITH_NULL_AND_9999_PARSER);
    }

    @Override
    public ActionImportDto newEmptyInstance() {
        return new ActionImportDto();
    }
}
