package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedIntervention;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedInterventionImporter.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.5/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedIntervention/PracticedInterventionImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.AgrosystInterventionType;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCyclePhaseDto;
import fr.inra.agrosyst.api.services.practiced.PracticedInterventionDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 05/02/15.
 */
public class PracticedInterventionImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycle.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedIntervention.class);
        log.debug(String.format("importfromstream"));

        PracticedInterventionImportModel model = new PracticedInterventionImportModel();
        // récupère le DTO
        Import<PracticedInterventionImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedInterventionImportDto dto : importer) {
            boolean error = false;

            PracticedInterventionDto interventionDto = new PracticedInterventionDto();
            Binder<PracticedInterventionImportDto, PracticedInterventionDto> binder = BinderFactory.newBinder(PracticedInterventionImportDto.class, PracticedInterventionDto.class);
            binder.copy(dto, interventionDto);

            // valid required fields
            error = validPhaseOrConnectionFields(importResults, line, dto, error);
            error = validPhase(importResults, line, dto, interventionDto, error);
            error = validConnection(importResults, line, dto, interventionDto, error);

            error = validType(importResults, line, dto, interventionDto, error);

            if (!error) {
                addInterventionToPhaseOrConnection(dto, interventionDto);
                importResults.addInfoLine(line, "INTERVENTION DU SYNTHÉTISÉ VALIDÉE, csvid: " + dto.getId());
                pz0IdToObject.put(PracticedInterventionDto.class,  dto.getId(), interventionDto);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "INTERVENTION DU SYNTHÉTISÉ IGNORÉE csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validPhaseOrConnectionFields(ImportResults importResults, long line, PracticedInterventionImportDto from, boolean error) {
        String practicedCropCyclePhaseId = from.getPracticedCropCyclePhaseId();
        String practicedCropCycleConnectionId = from.getPracticedCropCycleConnectionId();
        if(StringUtils.isBlank(practicedCropCyclePhaseId) && StringUtils.isBlank(practicedCropCycleConnectionId)){
            importResults.addErrorLine(line, "INTERVENTION IGNORÉE!, une des colonnes suivante doit-être renseigné: 'practicedcropcyclephase' ou 'practicedcropcycleconnection' mais aucune ne l'est.");
            error = true;
        }
        return error;
    }

    protected boolean validPhase(ImportResults importResults, long line, PracticedInterventionImportDto from, PracticedInterventionDto to, boolean error) {
        String phaseId = from.getPracticedCropCyclePhaseId();
        if (!error && StringUtils.isNotBlank(phaseId)) {
            PracticedCropCyclePhaseDto phaseDto = (PracticedCropCyclePhaseDto)pz0IdToObject.get(PracticedCropCyclePhaseDto.class, phaseId);
            if(phaseDto == null) {
                importResults.addErrorLine(line, String.format("INTERVENTION IGNORÉE!, la phase avec comme id %s n'esiste pas.", phaseId));
                error = true;
            }

        }
        return error;
    }

    protected boolean validConnection(ImportResults importResults, long line, PracticedInterventionImportDto from, PracticedInterventionDto to, boolean error) {
        String connectionId = from.getPracticedCropCycleConnectionId();
        if (!error && StringUtils.isNotBlank(connectionId)) {
            PracticedCropCycleConnectionDto  connectionDto = (PracticedCropCycleConnectionDto)pz0IdToObject.get(PracticedCropCycleConnectionDto.class, connectionId);
            if(connectionDto == null) {
                importResults.addErrorLine(line, String.format("INTERVENTION IGNORÉE!, la connexion avec comme id %s n'esiste pas.", connectionId));
                error = true;
            }
        }
        return error;
    }

    protected void addInterventionToPhaseOrConnection(PracticedInterventionImportDto from, PracticedInterventionDto to) {
        String connectionId = from.getPracticedCropCycleConnectionId();
        String phaseId = from.getPracticedCropCyclePhaseId();
        if (StringUtils.isNotBlank(connectionId)) {
            PracticedCropCycleConnectionDto  connectionDto = (PracticedCropCycleConnectionDto)pz0IdToObject.get(PracticedCropCycleConnectionDto.class, connectionId);
            connectionDto.addIntervention(to);
            pz0IdToObject.put(PracticedInterventionDto.class, PracticedCropCycleConnectionDto.class, from.getId(), connectionId);
        } else {
            PracticedCropCyclePhaseDto  phaseDto = (PracticedCropCyclePhaseDto)pz0IdToObject.get(PracticedCropCyclePhaseDto.class, phaseId);
            phaseDto.addIntervention(to);
            pz0IdToObject.put(PracticedInterventionDto.class, PracticedCropCyclePhaseDto.class, from.getId(), phaseId);
        }
    }


    protected boolean validType(ImportResults importResults, long line, PracticedInterventionImportDto from, PracticedInterventionDto to, boolean error) {
        String typeName = from.getTypeName();
        if(StringUtils.isNotBlank(typeName)){
            AgrosystInterventionType type = AgrosystInterventionType.valueOf(typeName);
            to.setType(type);
            if(type == null) {
                error = true;
                importResults.addErrorLine(line, String.format("INTERVENTION IGNORÉE!, le type d'intervention %s n'est pas reconnu.", type));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "INTERVENTION IGNORÉE!, la colonne 'type' n'est pas renseigné.");

        }
        return error;
    }


}
