package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleNodeImporter.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.5/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycleNode/PracticedCropCycleNodeImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.growingPlan.GrowingPlanAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle.PracticedCropCycleImportDto;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 04/02/15.
 */
public class PracticedCropCycleNodeImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycle.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycleNode.class);
        log.debug(String.format("importfromstream"));

        PracticedCropCycleNodeImportModel model = new PracticedCropCycleNodeImportModel();
        // récupère le DTO
        Import<PracticedCropCycleNodeImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleNodeImportDto dto : importer) {
            boolean error = false;

            PracticedCropCycleNodeDto cropCycleNode = new PracticedCropCycleNodeDto();
            Binder<PracticedCropCycleNodeImportDto, PracticedCropCycleNodeDto> binder = BinderFactory.newBinder(PracticedCropCycleNodeImportDto.class, PracticedCropCycleNodeDto.class);
            binder.copy(dto, cropCycleNode);

            // valid required fields
            error = validSeasonalPracticedSystemAffiliationAndAddNodeToIt(importResults, line, dto, cropCycleNode, error);

            error = validNodeCrop(importResults, line, dto, error);

            if (!error) {
                addNodeToCycle(dto, cropCycleNode);
                importResults.addInfoLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ VALIDÉ, csvid: " + dto.getId());
                String newNodeId = "new-node-" + dto.getId();
                cropCycleNode.setNodeId(newNodeId);
                pz0IdToObject.put(PracticedCropCycleNodeDto.class,  dto.getId(), cropCycleNode);
                pz0IdToObject.put(PracticedCropCycleNodeImportDto.class, dto.getId(), dto);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSeasonalPracticedSystemAffiliationAndAddNodeToIt(ImportResults importResults, long line, PracticedCropCycleNodeImportDto from, PracticedCropCycleNodeDto to, boolean error) {
        String practicedSeasonalCropCycleId = from.getPracticedSeasonalCropCycleId();

        if (StringUtils.isNotBlank(practicedSeasonalCropCycleId)) {
            PracticedSeasonalCropCycleDto seasonalCropCycleDto = (PracticedSeasonalCropCycleDto) pz0IdToObject.get(PracticedSeasonalCropCycleDto.class,practicedSeasonalCropCycleId);
            if (seasonalCropCycleDto == null) {
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, le system synthétisé n'a pu être retrouvé.");
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'practicedseasonalcropcycle' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    private static PracticedSystem getRelatedPracticedSystem(PracticedCropCycleNodeImportDto nodeImportDto) {
        PracticedSystem practicedSystem;
        String practicedSeasonalCropCycleId = nodeImportDto.getPracticedSeasonalCropCycleId();
        PracticedCropCycleImportDto practicedCropCycleImportDto = (PracticedCropCycleImportDto) pz0IdToObject.get(PracticedCropCycle.class, practicedSeasonalCropCycleId);
        PracticedSystemAndDependencies practicedSystemAndDependencies = (PracticedSystemAndDependencies) pz0IdToObject.get(PracticedSystem.class, practicedCropCycleImportDto.getPracticedSystemId());
        practicedSystem = practicedSystemAndDependencies.getEntity();
        return practicedSystem;
    }

    protected void addNodeToCycle(PracticedCropCycleNodeImportDto dto, PracticedCropCycleNodeDto cycleNodeDto) {
        String practicedSeasonalCropCycleId = dto.getPracticedSeasonalCropCycleId();
        PracticedSeasonalCropCycleDto seasonalCropCycleDto = (PracticedSeasonalCropCycleDto) pz0IdToObject.get(PracticedSeasonalCropCycleDto.class,practicedSeasonalCropCycleId);
        seasonalCropCycleDto.addNode(cycleNodeDto);
    }

    protected boolean validNodeCrop(ImportResults importResults, long line, PracticedCropCycleNodeImportDto from, boolean error) {
        if (!error) {
            DomainAndDependencies domainAndDependencies = getDomainAndDependenciesFromNode(from);
            Map<String, CroppingPlanEntryDto> croppingPlanEntryDtoByCode = domainAndDependencies.getCroppingPlanEntryDtosByCode();
            String cropCode = from.getCroppingPlanEntryCode();
            if (StringUtils.isNotBlank(cropCode)) {
                CroppingPlanEntryDto crop = croppingPlanEntryDtoByCode.get(cropCode);
                if(crop == null) {
                    importResults.addErrorLine(line, String.format("NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la culture dont le code est %s n'a pas été retrouvé sur les domaines ciblés.", cropCode));
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, "NOEUD DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉ!, la colonne 'croppingplanentrycode' n'est pas renseignée.");
                error = true;
            }
        }
        return error;
    }

    public static DomainAndDependencies getDomainAndDependenciesFromNode(PracticedCropCycleNodeImportDto nodeImportDto) {
        PracticedSystem practicedSystem = getRelatedPracticedSystem(nodeImportDto);
        GrowingPlan growingPlan = practicedSystem.getGrowingSystem().getGrowingPlan();
        GrowingPlanAndDependencies growingPlanAndDependencies = (GrowingPlanAndDependencies) pz0IdToRelatedObjectId.get(GrowingPlan.class, GrowingPlanAndDependencies.class, growingPlan);
        growingPlanAndDependencies.getDomainPZ0Id();
        return (DomainAndDependencies) pz0IdToObject.get(Domain.class, growingPlanAndDependencies.getDomainPZ0Id());
    }

}
