package fr.inra.agrosyst.services.pz0import.practicedSystem;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedSystemImporter.java 4750 2015-02-03 15:25:54Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.5/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/PracticedSystemImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.GrowingSystem;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.practiced.PracticedSystemService;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.services.ServiceContext;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 16/12/14.
 */
public class PracticedSystemImporter extends AbstractCSVImporter {

    protected PracticedSystemService practicedSystemService;

    private static final Log log = LogFactory.getLog(PracticedSystemImporter.class);
    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> growingSystemsByCsvId) {
        ImportResults importResults = new ImportResults(PracticedSystem.class);
        log.debug(String.format("importfromstream"));

        PracticedSystemImportModel model = new PracticedSystemImportModel();
        // récupère le DTO
        Import<PracticedSystemImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedSystemImportDto dto : importer) {
            boolean error = false;
            PracticedSystem practicedSystem = practicedSystemService.getPracticedSystem(null);

            Binder<PracticedSystemImportDto, PracticedSystem> practicedSystemBinder = BinderFactory.newBinder(PracticedSystemImportDto.class, PracticedSystem.class);
            practicedSystemBinder.copyExcluding(dto, practicedSystem,
                    PracticedSystem.PROPERTY_TOPIA_ID,
                    PracticedSystem.PROPERTY_GROWING_SYSTEM);

            // valid required fields
            error = validGrowingSystemAffiliation(importResults, line, dto, practicedSystem, growingSystemsByCsvId, error);

            //saveGrowingSytem(importResults, line, dto, growingSystem, refTypeAgricultureTopiaId);
            if (!error) {
                PracticedSystemAndDependencies practicedSystemAndDependencies = new PracticedSystemAndDependencies(practicedSystem);
                importResults.addEntity(dto.getId(), practicedSystemAndDependencies);
                importResults.addInfoLine(line, "SYSTÈME SYNTHÉTISÉ VALIDÉ, csvid: " + dto.getId());
                pz0IdToObject.put(PracticedSystem.class,  dto.getId(), practicedSystemAndDependencies);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "SYSTÈME SYNTHÉTISÉ IGNORÉ csvid:" + dto.getId());
            }

            line++;
        }
        return importResults;
    }

    protected boolean validGrowingSystemAffiliation(ImportResults importResults, long line, PracticedSystemImportDto dto, PracticedSystem practicedSystem, Map<String, EntityAndDependencies> growingSystemsByCsvIds, boolean error) {
        try {
            if (StringUtils.isNotBlank(dto.getGrowingSystemId())) {
                EntityAndDependencies entityAndDependencies = growingSystemsByCsvIds.get(dto.getGrowingSystemId());
                if (entityAndDependencies != null) {
                    practicedSystem.setGrowingSystem((GrowingSystem) entityAndDependencies.getEntity());
                } else {
                    importResults.addErrorLine(line, String.format("SYSTÈME SYNTHÉTISÉ IGNORÉ!, aucun système de culture n'est retrouvée avec l'identifiant suivant: %s", dto.getGrowingSystemId()));
                    error = true;
                }
            } else {
                importResults.addErrorLine(line, String.format("SYSTÈME SYNTHÉTISÉ IGNORÉ!, la colonne 'growingsystem' n'est pas renseignée pour le SDC \"%s\"!", dto.getName()));
                error = true;
            }
        } catch (ClassCastException e) {
            importResults.addErrorLine(line, String.format("SYSTÈME SYNTHÉTISÉ IGNORÉ!, système de culture non retrouvé pour le système synthétisé \"%s\"!", dto.getName()));
            error = true;
        }
        return error;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        super.init(serviceContext);
        practicedSystemService = getServiceFactory().newService(PracticedSystemService.class);
    }
}
