package fr.inra.agrosyst.services.pz0import.growingplan;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: GrowingPlanImportModel.java 4748 2015-02-03 09:28:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.5/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/growingplan/GrowingPlanImportModel.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 *
 * @author Antoine Schellenberger
 */
public class GrowingPlanImportModel extends AbstractAgrosystModelExtended<GrowingPlanImportDto> {

    public GrowingPlanImportModel() {
        super(';');

        newMandatoryColumn("topiaid", GrowingPlanImportDto.PROPERTY_ID);
        newIgnoredColumn("topiaversion");
        newMandatoryColumn("code", GrowingPlan.PROPERTY_CODE);
        newMandatoryColumn("domain", GrowingPlanImportDto.PROPERTY_DOMAIN_ID);
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", GrowingPlan.PROPERTY_NAME);
        newMandatoryColumn("description", GrowingPlan.PROPERTY_DESCRIPTION);
        newMandatoryColumn("goals", GrowingPlan.PROPERTY_GOALS);
        newMandatoryColumn("protocolreference", GrowingPlan.PROPERTY_PROTOCOL_REFERENCE);
        newMandatoryColumn("institutionalstructure", GrowingPlan.PROPERTY_INSTITUTIONAL_STRUCTURE);
        newMandatoryColumn("active", GrowingPlan.PROPERTY_ACTIVE, O_N_PARSER);
        newMandatoryColumn("validated", GrowingPlan.PROPERTY_VALIDATED, O_N_PARSER);
        newIgnoredColumn("validationdate");
//        newMandatoryColumn("validationdate", GrowingPlan.PROPERTY_VALIDATION_DATE, DATE_PARSER);
        newMandatoryColumn("updatedate", GrowingPlan.PROPERTY_UPDATE_DATE, DATE_PARSER);
        newMandatoryColumn("type", "typeDEPHYImportValues");
    }

    @Override
    public GrowingPlanImportDto newEmptyInstance() {
        return new GrowingPlanImportDto();
    }


}
