package fr.inra.agrosyst.services.pz0import.domain;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: ToolsCouplingImporter.java 4748 2015-02-03 09:28:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.5/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/ToolsCouplingImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Equipment;
import fr.inra.agrosyst.api.entities.MaterielWorkRateUnit;
import fr.inra.agrosyst.api.entities.ToolsCoupling;
import fr.inra.agrosyst.api.entities.ToolsCouplingImpl;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.domain.dto.ToolCouplingImportDto;
import fr.inra.agrosyst.services.pz0import.domain.model.ToolsCouplingImportModel;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 09/12/14.
 */
public class ToolsCouplingImporter extends AbstractCSVImporter {

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(ImportResults.class);

        ToolsCouplingImportModel model = new ToolsCouplingImportModel();
        Import<ToolCouplingImportDto> importer = Import.newImport(model, is);

        // match the csv line number.
        Long line = FIRST_LINE_NUMBER;
        for (ToolCouplingImportDto dto : importer) {
            boolean error = false;

            ToolsCoupling toolsCoupling = new ToolsCouplingImpl();

            Binder<ToolCouplingImportDto, ToolsCoupling> binder = BinderFactory.newBinder(ToolCouplingImportDto.class, ToolsCoupling.class);
            binder.copyExcluding(dto, toolsCoupling,
                    ToolsCoupling.PROPERTY_TOPIA_ID,
                    ToolsCoupling.PROPERTY_TRACTOR,
                    ToolsCoupling.PROPERTY_DOMAIN);

            toolsCoupling.setCode(csvCodeToAgrosystCode(ToolsCoupling.class, dto.getCode()));

            error = validTractor(importResults, line, dto, error, toolsCoupling);

            error = validToolCouplingToDomain(dto, dto, entitiesByCsvId, importResults, line, error);

            error = addToolCouplingWorkRateUnit(dto, toolsCoupling, importResults, line, error);

            if (!error) {
                importResults.addInfoLine(line, "COMBINAISON D'OUTILS VALIDÉE, csvid: " + dto.getId() + ", elle sera persistée avec le domaine: " + dto.getDomainId());
                pz0IdToObject.put(ToolsCoupling.class, dto.getId(), toolsCoupling);
                importResults.increaseAddedRecords();
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "COMBINAISON D'OUTILS IGNORÉE, csvid: " + dto.getId());
            }

            line++;
        }
        return  importResults;
    }

    protected boolean validTractor(ImportResults importResults, Long line, ToolCouplingImportDto dto, boolean error, ToolsCoupling toolsCoupling) {
        if (dto.isManualIntervention()) {
            if (StringUtils.isNotBlank(dto.getTractorId())) {
                error = true;
                importResults.addErrorLine(line, String.format("INTEVENTION MANUELLE IGNORÉE, un tracteur est renseigné csvid: %s", dto.getId()));
            }
        } else if (StringUtils.isNotBlank(dto.getTractorId())) {
            Equipment tractor = (Equipment) pz0IdToObject.get(Equipment.class, dto.getTractorId());
            if (tractor != null) {
                toolsCoupling.setTractor(tractor);
            } else {
                error = true;
                importResults.addErrorLine(line, String.format("COMBINAISON D'OUTILS IGNORÉE, le tracteur %s n'a pas été retrouvé csvid: %s", dto.getTractor() , dto.getId()));
            }
        } else {
            error = true;
            importResults.addErrorLine(line, "COMBINAISON D'OUTILS IGNORÉE, la colonne 'tractor' n'est pas renseignée csvid: " + dto.getId());
        }
        return error;
    }

    protected boolean validToolCouplingToDomain(ToolCouplingImportDto dto, ToolsCoupling toolsCoupling, Map<String, EntityAndDependencies> entitiesByCsvId, ImportResults importResults, long line, boolean error) {

        if (StringUtils.isNotBlank(dto.getDomainId())) {
            DomainAndDependencies domainAndDependencies = (DomainAndDependencies) entitiesByCsvId.get(dto.getDomainId());
            if (domainAndDependencies != null) {
                domainAndDependencies.addToolsCoupling(toolsCoupling);
            } else {
                importResults.addErrorLine(line, String.format("COMBINAISON D'OUTILS IGNORÉE, le domaine avec comme identifiant:%s, n'a pas été retrouvé pour la combinaison d'outil: %s",dto.getDomainId(), dto.getId()));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "COMBINAISON D'OUTILS IGNORÉE, la colonne 'domain' n'est pas renseignée, csvid: " + dto.getId());
            error = true;
        }
        return error;
    }

    protected boolean addToolCouplingWorkRateUnit(ToolCouplingImportDto dto, ToolsCoupling toolsCoupling, ImportResults importResults, long line, boolean error) {
        MaterielWorkRateUnit workRateUnit = null;
        String value = dto.getWorkrateUnitImporterValue();
        if (StringUtils.isNotBlank(value)) {
            try {
                workRateUnit = MaterielWorkRateUnit.valueOf(value);
                toolsCoupling.setWorkRateUnit(workRateUnit);
            } catch (IllegalArgumentException ex) {
                error = true;
                importResults.addErrorLine(line, String.format("COMBINAISON D'OUTILS IGNORÉE! Unité de rendement non supportée, %s\"!", value));
            }
        }
        return error;
    }
}
