package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedIntervention;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedInterventionImportModel.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.4/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedIntervention/PracticedInterventionImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedIntervention;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 05/02/15.
 */
public class PracticedInterventionImportModel extends AbstractAgrosystModelExtended<PracticedInterventionImportDto> {

    protected PracticedInterventionImportModel() {
        super(';');
        newMandatoryColumn("topiaid", "id");
        newIgnoredColumn("topiaversion");
        newIgnoredColumn("topiacreatedate");
        newMandatoryColumn("name", PracticedIntervention.PROPERTY_NAME);
        newMandatoryColumn("comment", PracticedIntervention.PROPERTY_COMMENT);
        newMandatoryColumn("startingperioddate", PracticedIntervention.PROPERTY_STARTING_PERIOD_DATE);
        newMandatoryColumn("endingperioddate", PracticedIntervention.PROPERTY_ENDING_PERIOD_DATE);
        newMandatoryColumn("intermediatecrop", PracticedIntervention.PROPERTY_INTERMEDIATE_CROP, T_F_PARSER);
        newMandatoryColumn("tillagedepth", PracticedIntervention.PROPERTY_TILLAGE_DEPTH, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("othertoolsettings", PracticedIntervention.PROPERTY_OTHER_TOOL_SETTINGS);
        newMandatoryColumn("workrate", PracticedIntervention.PROPERTY_WORK_RATE, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("progressionspeed", PracticedIntervention.PROPERTY_PROGRESSION_SPEED, INTEGER_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("involvedpeoplenumber", PracticedIntervention.PROPERTY_INVOLVED_PEOPLE_NUMBER, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("spatialfrequency", PracticedIntervention.PROPERTY_SPATIAL_FREQUENCY, DOUBLE_PARSER);
        newMandatoryColumn("temporalfrequency", PracticedIntervention.PROPERTY_TEMPORAL_FREQUENCY, DOUBLE_PARSER);
        newMandatoryColumn("practicedcropcyclephase", "practicedCropCyclePhaseId");
        newMandatoryColumn("practicedcropcycleconnection", "practicedCropCycleConnectionId");
        newMandatoryColumn("type", "typeName");
    }

    @Override
    public PracticedInterventionImportDto newEmptyInstance() {
        return new PracticedInterventionImportDto();
    }
}
