package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleNodeImportModel.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.4/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycleNode/PracticedCropCycleNodeImportModel.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */


import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.services.pz0import.AbstractAgrosystModelExtended;

/**
 * Created by davidcosse on 04/02/15.
 */
public class PracticedCropCycleNodeImportModel extends AbstractAgrosystModelExtended<PracticedCropCycleNodeImportDto> {

    protected PracticedCropCycleNodeImportModel() {
        super(';');
        newMandatoryColumn("topiaId", "id");
        newMandatoryColumn("rank", "x", INT_PARSER);
        newMandatoryColumn("y", PracticedCropCycleNode.PROPERTY_Y, INT_PARSER);
        newMandatoryColumn("endcycle", PracticedCropCycleNode.PROPERTY_END_CYCLE, T_F_PARSER);
        newMandatoryColumn("croppingplanentrycode", PracticedCropCycleNode.PROPERTY_CROPPING_PLAN_ENTRY_CODE);
        newMandatoryColumn("samecampaignaspreviousnode", PracticedCropCycleNode.PROPERTY_SAME_CAMPAIGN_AS_PREVIOUS_NODE, T_F_PARSER);
        newMandatoryColumn("initnodefrequency", PracticedCropCycleNode.PROPERTY_INIT_NODE_FREQUENCY, DOUBLE_WITH_NULL_AND_9999_PARSER);
        newMandatoryColumn("practicedseasonalcropcycle", "practicedSeasonalCropCycleId");
    }

    @Override
    public PracticedCropCycleNodeImportDto newEmptyInstance() {
        return new PracticedCropCycleNodeImportDto();
    }
}
