package fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleConnection;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: PracticedCropCycleConnectionImporter.java 4775 2015-02-10 15:13:34Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.4/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/practicedSystem/practicedCropCycleConnection/PracticedCropCycleConnectionImporter.java $
 * %%
 * Copyright (C) 2013 - 2015 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import fr.inra.agrosyst.api.entities.Domain;
import fr.inra.agrosyst.api.entities.GrowingPlan;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycle;
import fr.inra.agrosyst.api.entities.practiced.PracticedCropCycleNode;
import fr.inra.agrosyst.api.entities.practiced.PracticedSystem;
import fr.inra.agrosyst.api.services.domain.CroppingPlanEntryDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleConnectionDto;
import fr.inra.agrosyst.api.services.practiced.PracticedCropCycleNodeDto;
import fr.inra.agrosyst.api.services.practiced.PracticedSeasonalCropCycleDto;
import fr.inra.agrosyst.api.services.pz0.EntityAndDependencies;
import fr.inra.agrosyst.api.services.pz0.ImportResults;
import fr.inra.agrosyst.api.services.pz0.domains.DomainAndDependencies;
import fr.inra.agrosyst.api.services.pz0.growingPlan.GrowingPlanAndDependencies;
import fr.inra.agrosyst.api.services.pz0.practicedSystem.PracticedSystemAndDependencies;
import fr.inra.agrosyst.services.pz0import.AbstractCSVImporter;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycle.PracticedCropCycleImportDto;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImportDto;
import fr.inra.agrosyst.services.pz0import.practicedSystem.practicedCropCycleNode.PracticedCropCycleNodeImporter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Import;
import org.nuiton.util.beans.Binder;
import org.nuiton.util.beans.BinderFactory;

import java.io.InputStream;
import java.util.Map;

/**
 * Created by davidcosse on 04/02/15.
 */
public class PracticedCropCycleConnectionImporter extends AbstractCSVImporter {

    private static final Log log = LogFactory.getLog(PracticedCropCycle.class);

    @Override
    public ImportResults importFromStream(InputStream is, Map<String, EntityAndDependencies> entitiesByCsvId) {
        ImportResults importResults = new ImportResults(PracticedCropCycleNode.class);
        log.debug(String.format("importfromstream"));

        PracticedCropCycleConnectionImportModel model = new PracticedCropCycleConnectionImportModel();
        // récupère le DTO
        Import<PracticedCropCycleConnectionImportDto> importer = Import.newImport(model, is);

        // match the first csv line number with data (not header).
        long line = FIRST_LINE_NUMBER;
        for (PracticedCropCycleConnectionImportDto dto : importer) {
            boolean error = false;

            PracticedCropCycleConnectionDto connectionDto = new PracticedCropCycleConnectionDto();
            Binder<PracticedCropCycleConnectionImportDto, PracticedCropCycleConnectionDto> binder = BinderFactory.newBinder(PracticedCropCycleConnectionImportDto.class, PracticedCropCycleConnectionDto.class);
            binder.copy(dto, connectionDto);

            // valid required fields
            error = validSource(importResults, line, dto, connectionDto, error);

            error = validTarget(importResults, line, dto, connectionDto, error);

            error = validIntermediateCrop(importResults, line, dto, error);

            if (!error) {
                setSourceAndTargetToConnection(dto, connectionDto);
                addConnectionToCycle(dto, connectionDto);
                importResults.addInfoLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ VALIDÉE, csvid: " + dto.getId());
                pz0IdToObject.put(PracticedCropCycleConnectionDto.class,  dto.getId(), connectionDto);
            } else {
                importResults.increaseIgnoredRecords();
                importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE csvid:" + dto.getId());
            }
            line++;
        }
        return importResults;
    }

    protected boolean validSource(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, PracticedCropCycleConnectionDto connectionDto, boolean error) {
        String sourceId = connectionImportDto.getSourceId();

        if (StringUtils.isNotBlank(sourceId)) {
            PracticedCropCycleNodeDto practicedCropCycleNodeDto = (PracticedCropCycleNodeDto) pz0IdToObject.get(PracticedCropCycleNodeDto.class, sourceId);
            if (practicedCropCycleNodeDto == null) {
                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, le noeud source avec comme identifiant %s n'a pu être retrouvé.", sourceId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'source' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    protected boolean validTarget(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, PracticedCropCycleConnectionDto connectionDto, boolean error) {
        String targetId = connectionImportDto.getTargetId();

        if (StringUtils.isNotBlank(targetId)) {
            PracticedCropCycleNodeDto practicedCropCycleNodeDto = (PracticedCropCycleNodeDto) pz0IdToObject.get(PracticedCropCycleNodeDto.class, targetId);
            if (practicedCropCycleNodeDto == null) {
                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, le noeud source avec comme identifiant %s n'a pu être retrouvé.", targetId));
                error = true;
            }
        } else {
            importResults.addErrorLine(line, "CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la colonne 'target' n'est pas renseignée.");
            error = true;
        }
        return error;
    }

    protected void addConnectionToCycle(PracticedCropCycleConnectionImportDto dto, PracticedCropCycleConnectionDto connectionDto) {
        PracticedCropCycleNodeImportDto nodeImportDto = (PracticedCropCycleNodeImportDto) pz0IdToObject.get(PracticedCropCycleNodeImportDto.class, dto.getTargetId());
        PracticedSeasonalCropCycleDto seasonalCropCycleDto = (PracticedSeasonalCropCycleDto) pz0IdToObject.get(PracticedSeasonalCropCycleDto.class,nodeImportDto.getPracticedSeasonalCropCycleId());
        seasonalCropCycleDto.addConnection(connectionDto);
    }

    protected PracticedCropCycleNodeDto setSourceAndTargetToConnection(PracticedCropCycleConnectionImportDto dto, PracticedCropCycleConnectionDto connectionDto) {
        String sourceId = dto.getSourceId();
        String targetId = dto.getTargetId();
        PracticedCropCycleNodeDto sourceNode = (PracticedCropCycleNodeDto) pz0IdToObject.get(PracticedCropCycleNodeDto.class, sourceId);
        PracticedCropCycleNodeDto targetedNode = (PracticedCropCycleNodeDto) pz0IdToObject.get(PracticedCropCycleNodeDto.class, targetId);
        connectionDto.setSourceId(sourceNode.getNodeId());
        connectionDto.setTargetId(targetedNode.getNodeId());
        return targetedNode;
    }


    protected boolean validIntermediateCrop(ImportResults importResults, long line, PracticedCropCycleConnectionImportDto connectionImportDto, boolean error) {
        if (!error && StringUtils.isNotBlank(connectionImportDto.getIntermediateCroppingPlanEntryCode())) {
            PracticedCropCycleNodeImportDto importedNode = (PracticedCropCycleNodeImportDto) pz0IdToObject.get(PracticedCropCycleNodeImportDto.class, connectionImportDto.getTargetId());

            DomainAndDependencies domainAndDependencies = PracticedCropCycleNodeImporter.getDomainAndDependenciesFromNode(importedNode);
            Map<String, CroppingPlanEntryDto> croppingPlanEntryDtoByCode = domainAndDependencies.getCroppingPlanEntryDtosByCode();
            String cropCode = connectionImportDto.getIntermediateCroppingPlanEntryCode();
            CroppingPlanEntryDto crop = croppingPlanEntryDtoByCode.get(cropCode);
            if(crop == null) {
                importResults.addErrorLine(line, String.format("CONNEXION DU CYCLE SAISONNIER DE CULTURE DU SYNTHÉTISÉ IGNORÉE!, la culture dont le code est %s n'a pas été retrouvé sur les domaines ciblés.", cropCode));
                error = true;
            }
        }
        return error;
    }

}
