package fr.inra.agrosyst.services.pz0import.domain.dto;

/*
 * #%L
 * Agrosyst :: Services
 * $Id: DomainImportDto.java 4748 2015-02-03 09:28:19Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.4/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/domain/dto/DomainImportDto.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */
import fr.inra.agrosyst.api.entities.DomainImpl;
import fr.inra.agrosyst.api.entities.referential.RefLegalStatus;

public class DomainImportDto extends DomainImpl {

    /**
     * serialVersionUID.
     */
    private static final long serialVersionUID = 8435193675746925772L;

    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_LOCATION_ID = "locationId";
    public static final String PROPERTY_LEGAL_STATUS_ID = "legalStatusId";
    public static final String PROPERTY_OTEX18_ID = "refOtex18Id";
    public static final String PROPERTY_OTEX70_ID = "refOtex70Id";
    public static final String PROPERTY_DEFAULT_WEATHER_STATION_ID = "defaultWeatherStationId";
    // we use name to be able to manage error while parsing the file
    public static final String PROPERTY_TYPE_NAME = "typeName";
    public static final String PROPERTY_ZONING_NAME = "zoningName";

    protected String id;
    protected String locationId;
    protected String legalStatusId;
    protected String refOtex18Id;
    protected String refOtex70Id;
    protected String defaultWeatherStationId;
    protected String typeName;
    protected String zoningName;

    protected RefLegalStatus refLegalStatus;

    public String getDefaultWeatherStationId() {
        return defaultWeatherStationId;
    }

    public void setDefaultWeatherStationId(String defaultWeatherStationId) {
        this.defaultWeatherStationId = defaultWeatherStationId;
    }

    public String getRefOtex18Id() {
        return refOtex18Id;
    }

    public void setRefOtex18Id(String refOtex18Id) {
        this.refOtex18Id = refOtex18Id;
    }

    public String getRefOtex70Id() {
        return refOtex70Id;
    }

    public void setRefOtex70Id(String refOtex70Id) {
        this.refOtex70Id = refOtex70Id;
    }

    public String getLegalStatusId() {
        return legalStatusId;
    }

    public void setLegalStatusId(String legalStatusId) {
        this.legalStatusId = legalStatusId;
    }

    public String getLocationId() {
        return locationId;
    }

    public void setLocationId(String locationId) {
        this.locationId = locationId;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTypeName() {
        return typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getZoningName() {
        return zoningName;
    }

    public void setZoningName(String zoningName) {
        this.zoningName = zoningName;
    }
}
