package fr.inra.agrosyst.services.pz0import;

/*
 * #%L
 * Agrosyst :: Command Line Interface
 * $Id: AbstractCSVImporter.java 4760 2015-02-05 10:33:27Z dcosse $
 * $HeadURL: https://svn.codelutin.com/agrosyst/tags/agrosyst-1.4.4/agrosyst-cli/src/main/java/fr/inra/agrosyst/services/pz0import/AbstractCSVImporter.java $
 * %%
 * Copyright (C) 2013 - 2014 INRA
 * %%
 * INRA - Tous droits réservés
 * #L%
 */

import com.google.common.collect.Maps;
import fr.inra.agrosyst.api.entities.AgrosystTopiaPersistenceContext;
import fr.inra.agrosyst.api.services.ServiceFactory;
import fr.inra.agrosyst.services.DefaultServiceFactory;
import fr.inra.agrosyst.services.ServiceContext;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.commons.collections4.map.MultiKeyMap;
import org.apache.commons.lang3.StringUtils;

/**
 *
 * @author Antoine Schellenberger
 */
public abstract class AbstractCSVImporter implements ICsvImporter {

    protected ServiceContext serviceContext;
    protected ServiceFactory serviceFactory;

    // map that allow to keep relation between entities throw there code as describe is the Pz0 csv files
    protected static MultiKeyMap<Object, String> pz0CodeToAgrosystCode = new MultiKeyMap<Object, String>();
    protected static MultiKeyMap<Object, Object> pz0IdToObject = new MultiKeyMap<Object, Object>();
    // use to be able from a PZ0 id to find related objects ex: GrowingPlan, DomainAndDependencies.class -> DomainAndDependencies
    protected static MultiKeyMap<Object, Object> pz0IdToRelatedObjectId = new MultiKeyMap<Object, Object>();

    // line 1 is file header
    protected final Long FIRST_LINE_NUMBER = 2L;


    public AgrosystTopiaPersistenceContext getPersistenceContext() {
        return serviceContext.getPersistenceContext();
    }
    
    public ServiceFactory getServiceFactory() {
        if (serviceFactory == null) {
            serviceFactory = new DefaultServiceFactory(serviceContext);
        }
        return serviceFactory;
    }

    @Override
    public void init(ServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }


    /**
     * Convert csv code to Agrosyst code format.
     * Maintain a map of object's class, csv code to Agrosyst Code allowing to keep affiliation.
     * @param _class the class of the targeted code
     * @param scvCode the csv code
     * @return the Agrosyst code
     */
    public String csvCodeToAgrosystCode(Class _class, String scvCode) {
        String agrosystCode = null;
        if (StringUtils.isNotBlank(scvCode)) {
            agrosystCode = pz0CodeToAgrosystCode.get(_class, scvCode);
            if (StringUtils.isBlank(agrosystCode)) {
                agrosystCode = UUID.randomUUID().toString();
                pz0CodeToAgrosystCode.put(_class, scvCode, agrosystCode);
            }
        }

        return agrosystCode;
    }

}
